/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.baku;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.baku.BeroCannonProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class BeroCannonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bero_cannon", new Pair[]{ImmutablePair.of((Object)"Transforms the user's tongue into a cannon and fires a random block from their inventory.", null)});
    private static final float COOLDOWN = 40.0f;
    public static final AbilityCore<BeroCannonAbility> INSTANCE = new AbilityCore.Builder<BeroCannonAbility>("Bero Cannon", AbilityCategory.DEVIL_FRUITS, BeroCannonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.BLUNT).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public BeroCannonAbility(AbilityCore<BeroCannonAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addCanUseCheck(this::canStartAbility);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<ItemStack> projectiles = this.getBlocksInInventory(entity);
        if (!projectiles.isEmpty()) {
            this.projectileComponent.shoot(entity);
            ItemStack stack = projectiles.stream().findFirst().orElse(null);
            if (stack != null && stack.func_190916_E() > 1) {
                stack.func_190918_g(1);
            }
        }
        this.cooldownComponent.startCooldown(entity, 40.0f);
    }

    private BeroCannonProjectile createProjectile(LivingEntity entity) {
        BeroCannonProjectile proj = new BeroCannonProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private List<ItemStack> getBlocksInInventory(LivingEntity entity) {
        ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
        for (ItemStack item : ItemsHelper.getInventoryItems(entity)) {
            if (item == null || !(item.func_77973_b() instanceof BlockItem) || DefaultProtectionRules.CORE_FOLIAGE_ORE.getApprovedBlocks().stream().anyMatch(p -> p == ((BlockItem)item.func_77973_b()).func_179223_d().getRegistryName())) continue;
            projectiles.add(item);
            break;
        }
        return projectiles;
    }

    private AbilityUseResult canStartAbility(LivingEntity entity, IAbility ability) {
        if (this.getBlocksInInventory(entity).isEmpty()) {
            return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_BLOCKS);
        }
        return AbilityUseResult.success();
    }
}

