/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.baku;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BakuMunchAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "baku_munch", new Pair[]{ImmutablePair.of((Object)"Allows the user to eat a big chunk of blocks in front of him, obtaining all of them as blocks in their inventory", null)});
    private static final float COOLDOWN = 60.0f;
    public static final AbilityCore<BakuMunchAbility> INSTANCE = new AbilityCore.Builder<BakuMunchAbility>("Baku Munch", AbilityCategory.DEVIL_FRUITS, BakuMunchAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f)).build();
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(100);

    public BakuMunchAbility(AbilityCore<BakuMunchAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, 16.0);
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        if (MathHelper.func_76133_a((double)entity.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c)) < 5.0f) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (int x = -2; x < 2; ++x) {
                for (int y = 0; y < 3; ++y) {
                    for (int z = -2; z < 2; ++z) {
                        int posX = (int)mop.func_216347_e().field_72450_a + x;
                        int posY = (int)mop.func_216347_e().field_72448_b - y;
                        int posZ = (int)mop.func_216347_e().field_72449_c + z;
                        mutpos.func_181079_c(posX, posY, posZ);
                        Block tempBlock = entity.field_70170_p.func_180495_p((BlockPos)mutpos).func_177230_c();
                        if (tempBlock.func_203417_a(ModTags.Blocks.KAIROSEKI) || !AbilityHelper.placeBlockIfAllowed(entity, (BlockPos)mutpos, Blocks.field_150350_a.func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                        if (entity instanceof PlayerEntity) {
                            ((PlayerEntity)entity).field_71071_by.func_70441_a(new ItemStack((IItemProvider)tempBlock));
                        }
                        positions.add(mutpos.func_185334_h());
                    }
                }
            }
            if (positions.size() > 0) {
                this.details.setPositions(positions);
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
            }
        }
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }
}

