/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.TempoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModQuests;

public class WeatherCloudTempo
extends TempoAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "weather_cloud_tempo", new Pair[]{ImmutablePair.of((Object)"Creates a cloud that can further be used by other Tempos", null)});
    public static final AbilityCore<WeatherCloudTempo> INSTANCE = new AbilityCore.Builder<WeatherCloudTempo>("Weather Cloud Tempo", AbilityCategory.STYLE, AbilityType.PASSIVE, WeatherCloudTempo::new).addDescriptionLine(TempoAbility.getTooltip(false, WeatherBallKind.COOL, WeatherBallKind.HEAT)).addDescriptionLine(DESCRIPTION).setUnlockCheck(WeatherCloudTempo::canUnlock).build();

    public WeatherCloudTempo(AbilityCore<WeatherCloudTempo> core) {
        super((AbilityCore)core);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_01);
    }
}

