/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.TempoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.WeatherCloudEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ThunderstormTempo
extends TempoAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "thunderstorm_tempo", new Pair[]{ImmutablePair.of((Object)"Hits multiple enemies below the cloud with multiple lightning bolts", null)});
    public static final AbilityCore<ThunderstormTempo> INSTANCE = new AbilityCore.Builder<ThunderstormTempo>("Thunderstorm Tempo", AbilityCategory.STYLE, AbilityType.PASSIVE, ThunderstormTempo::new).addDescriptionLine(TempoAbility.getTooltip(true, 5, WeatherBallKind.THUNDER)).addDescriptionLine(DESCRIPTION).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(ThunderstormTempo::canUnlock).build();

    public ThunderstormTempo(AbilityCore<ThunderstormTempo> core) {
        super((AbilityCore)core);
    }

    public void useTempo(LivingEntity entity, WeatherCloudEntity cloud) {
        List<LivingEntity> targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 25.0, ModEntityPredicates.getEnemyFactions(entity));
        Collections.shuffle(targets);
        for (LivingEntity target : targets) {
            if (!this.isUnderWeatherCloud(cloud, target)) continue;
            double distance = Math.sqrt(target.func_213303_ch().func_72441_c(0.0, 14.0, 0.0).func_186679_c(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()));
            if (!(target.func_226278_cu_() <= cloud.func_226278_cu_()) || !entity.func_70685_l((Entity)target)) continue;
            LightningEntity bolt = new LightningEntity((Entity)entity, target.func_226277_ct_(), target.func_226278_cu_() + 14.0, target.func_226281_cx_(), 0.0f, 90.0f, (float)(distance + 1.0), 5.0f, INSTANCE);
            bolt.setAngle(30);
            bolt.setBranches(6);
            bolt.setSegments(15);
            bolt.setColor(new Color(253, 208, 35, 205));
            bolt.setSize(0.05f);
            bolt.setExplosion(1);
            bolt.setDamage(60.0f);
            bolt.setMaxLife(20);
            entity.field_70170_p.func_217376_c((Entity)bolt);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_03);
    }
}

