/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.ArtOfWeatherHelper;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ChargedTempoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;

public class HeatEggTempo
extends ChargedTempoAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "heat_egg_tempo", new Pair[]{ImmutablePair.of((Object)"Used to imbue the Clima Tact with Heat Balls, while active it doubles the physical damage dealt by the clima tact", null)});
    private static final int HOLD_TIME = 200;
    public static final AbilityCore<HeatEggTempo> INSTANCE = new AbilityCore.Builder<HeatEggTempo>("Heat Egg Tempo", AbilityCategory.STYLE, AbilityType.PASSIVE, HeatEggTempo::new).addDescriptionLine(CHARGED_TEMPO_DESCRIPTION).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip(200.0f)).setUnlockCheck(HeatEggTempo::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::startContinuousEvent).addTickEvent(100, this::tickContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private ItemStack climaTactRef = ItemStack.field_190927_a;

    public HeatEggTempo(AbilityCore<HeatEggTempo> core) {
        super((AbilityCore)core);
        this.addComponents(this.continuousComponent);
        this.addCanUseCheck(ArtOfWeatherHelper::needsSorceryClimaTact);
    }

    @Override
    public WeatherBallKind[] getTempoOrder() {
        return new WeatherBallKind[]{WeatherBallKind.HEAT, WeatherBallKind.HEAT, WeatherBallKind.HEAT};
    }

    @Override
    public void useTempo(LivingEntity entity) {
        this.continuousComponent.startContinuity(entity);
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.climaTactRef = entity.func_184614_ca();
        ClimaTactItem.setDamageModifier(this.climaTactRef, 2.0);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.HEAT_EGG_TEMPO.get(), 200, 0));
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() >= 200.0f) {
            ItemStack mainHand = entity.func_184614_ca();
            if (!this.climaTactRef.func_190926_b() && mainHand.equals(this.climaTactRef)) {
                this.continuousComponent.stopContinuity(entity);
            } else if (!mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ClimaTactItem) {
                this.climaTactRef = entity.func_184614_ca();
            }
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        ClimaTactItem.setDamageModifier(this.climaTactRef, 1.0);
        this.climaTactRef = ItemStack.field_190927_a;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_04);
    }
}

