/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.EntityRayTraceResult;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ChargedTempoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.WeatherBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class WeatherBallAbility
extends Ability {
    private static final float COOLDOWN = 10.0f;
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.WEATHER_BALLS, new AbilityPool2[0]);

    public WeatherBallAbility(AbilityCore core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.poolComponent);
        this.addCanUseCheck(AbilityHelper::requiresClimaTact);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, 1.5);
        ItemStack stack = entity.func_184614_ca();
        if (stack.func_190926_b()) {
            this.cooldownComponent.startCooldown(entity, 10.0f);
            return;
        }
        ClimaTactItem climaTact = (ClimaTactItem)stack.func_77973_b();
        entity.func_184614_ca().func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        if (entity.func_213453_ef()) {
            climaTact.chargeWeatherBall(stack, this.getKind());
            this.checkForChargeTempo(entity, trace);
        } else {
            WeatherBallProjectile proj = this.getWeatherBallEntity(entity, trace);
            entity.field_70170_p.func_217376_c((Entity)proj);
        }
        this.cooldownComponent.startCooldown(entity, 10.0f);
    }

    private void checkForChargeTempo(LivingEntity entity, EntityRayTraceResult trace) {
        ItemStack stack = entity.func_184614_ca();
        ClimaTactItem climaTact = (ClimaTactItem)stack.func_77973_b();
        IAbilityData props = AbilityDataCapability.get(entity);
        WyHelper.spawnParticleEffect(this.getParticleEffect(), (Entity)entity, trace.func_216347_e().func_82615_a(), entity.func_226278_cu_(), trace.func_216347_e().func_82616_c());
        WeatherBallKind[] charge = climaTact.checkCharge(stack);
        if (charge.length > 0) {
            Predicate<IAbility> check = abl -> AbilityCategory.STYLE.isAbilityPartofCategory().test((IAbility)abl) && abl instanceof ChargedTempoAbility;
            Set availableTempos = props.getPassiveAbilities(check);
            if (availableTempos.size() <= 0) {
                this.failedTempo(entity, trace, stack);
                return;
            }
            boolean failedTempo = true;
            for (ChargedTempoAbility tempo : availableTempos) {
                if (!Arrays.equals((Object[])charge, (Object[])tempo.getTempoOrder()) || !tempo.canUse(entity).isSuccess()) continue;
                tempo.use(entity);
                climaTact.emptyCharge(stack);
                failedTempo = false;
            }
            if (failedTempo) {
                this.failedTempo(entity, trace, stack);
            }
        }
    }

    private void failedTempo(LivingEntity entity, EntityRayTraceResult trace, ItemStack stack) {
        ClimaTactItem climaTact = (ClimaTactItem)stack.func_77973_b();
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.FAILED_TEMPO.get(), (Entity)entity, trace.func_216347_e().func_82615_a(), entity.func_226278_cu_(), trace.func_216347_e().func_82616_c());
        climaTact.emptyCharge(stack);
    }

    public abstract WeatherBallKind getKind();

    public abstract ParticleEffect<?> getParticleEffect();

    public abstract WeatherBallProjectile getWeatherBallEntity(LivingEntity var1, EntityRayTraceResult var2);
}

