/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class ZoomAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "zoom", new Pair[]{ImmutablePair.of((Object)"Zooms into the direction the user is looking, massively reduces inaccuracy when shooting projectiles.", null)});
    public static final AbilityCore<ZoomAbility> INSTANCE = new AbilityCore.Builder<ZoomAbility>("Zoom", AbilityCategory.EQUIPMENT, ZoomAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(ZoomAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true);

    public ZoomAbility(AbilityCore<ZoomAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addCanUseCheck(this::canStartAbility);
        this.addUseEvent(this::onUseEvent);
        this.addTickEvent(this::onTickEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onTickEvent(LivingEntity entity, IAbility ability) {
        ItemStack headStack;
        if (this.isContinuous() && ((headStack = entity.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() || headStack.func_77973_b() != ModArmors.SNIPER_GOGGLES.get())) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private AbilityUseResult canStartAbility(LivingEntity entity, IAbility ability) {
        ItemStack headStack = entity.func_184582_a(EquipmentSlotType.HEAD);
        if (headStack.func_190926_b() || headStack.func_77973_b() != ModArmors.SNIPER_GOGGLES.get()) {
            return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NEED_SNIPER_GOGGLES);
        }
        return AbilityUseResult.success();
    }

    private static boolean canUnlock(LivingEntity entity) {
        ItemStack headStack = entity.func_184582_a(EquipmentSlotType.HEAD);
        return !headStack.func_190926_b() && headStack.func_77973_b() == ModArmors.SNIPER_GOGGLES.get();
    }
}

