/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class StealPunchAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "steal_punch", new Pair[]{ImmutablePair.of((Object)"Hits the enemy and throws their held item away from them.", null)});
    private static final float COOLDOWN = 160.0f;
    public static final AbilityCore<StealPunchAbility> INSTANCE = new AbilityCore.Builder<StealPunchAbility>("Steal Punch", AbilityCategory.STYLE, StealPunchAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ContinuousComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();

    public StealPunchAbility(AbilityCore<StealPunchAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        ItemStack droppedStack = ItemStack.field_190927_a;
        if (!target.func_184614_ca().func_190926_b()) {
            droppedStack = target.func_184614_ca();
        } else if (!target.func_184592_cb().func_190926_b()) {
            droppedStack = target.func_184592_cb();
        } else if (target.func_213343_cS() > 0.0f) {
            for (ItemStack armorStack : target.func_184193_aE()) {
                if (armorStack == null || armorStack.func_190926_b() || !(target.func_70681_au().nextDouble() < 0.35)) continue;
                droppedStack = armorStack;
                break;
            }
        }
        if (droppedStack != null && !droppedStack.func_190926_b()) {
            Vector3d lookVec = target.func_70040_Z();
            entity.func_70107_b(target.func_226277_ct_() + lookVec.field_72450_a, target.func_226278_cu_(), target.func_226281_cx_() + lookVec.field_72449_c);
            double d0 = target.func_226280_cw_() - (double)0.3f;
            ItemEntity itementity = new ItemEntity(target.field_70170_p, target.func_226277_ct_(), d0, target.func_226281_cx_(), droppedStack.func_77946_l());
            itementity.func_174867_a(40);
            itementity.func_200216_c(target.func_110124_au());
            float f = target.func_70681_au().nextFloat() * 1.5f;
            float f1 = target.func_70681_au().nextFloat() * ((float)Math.PI * 2);
            AbilityHelper.setDeltaMovement((Entity)itementity, -MathHelper.func_76126_a((float)f1) * f, 0.75, MathHelper.func_76134_b((float)f1) * f);
            target.field_70170_p.func_217376_c((Entity)itementity);
            droppedStack.func_190918_g(droppedStack.func_190916_E());
        }
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchCooldown() {
        return 160.0f;
    }
}

