/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.MH5CloudEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MH5Ability
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mh5", new Pair[]{ImmutablePair.of((Object)"Charges a deathly poison bomb causing all within its radius to die when inhaling the resulting gas.", null)});
    private static final int COOLDOWN = 1200;
    private static final int CHARGE_TIME = 200;
    public static final int RANGE = 100;
    public static final AbilityCore<MH5Ability> INSTANCE = new AbilityCore.Builder<MH5Ability>("MH5", AbilityCategory.EQUIPMENT, MH5Ability::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1200.0f), ChargeComponent.getTooltip(200.0f), RangeComponent.getTooltip(100.0f, RangeComponent.RangeType.AOE)).setUnlockCheck(MH5Ability::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private BlockPos targetPosition;
    private float initialHealth;
    private double hpThreshold;

    public MH5Ability(AbilityCore<MH5Ability> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.animationComponent);
        this.addCanUseCheck(this::canUse);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 200.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.MH5_CHARGING);
        this.initialHealth = entity.func_110143_aJ();
        this.hpThreshold = WyHelper.percentage(20.0, entity.func_110138_aP());
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 200, 0));
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if ((double)entity.func_110143_aJ() <= (double)this.initialHealth - this.hpThreshold) {
            this.chargeComponent.forceStopCharging(entity);
            entity.func_195063_d((Effect)ModEffects.MOVEMENT_BLOCKED.get());
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 100, 0));
            this.cooldownComponent.startCooldown(entity, 1200.0f);
            return;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CHARGE_MH5_BOMB.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        if (this.targetPosition == null) {
            Vector3d startVec = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
            Vector3d endVec = startVec.func_178787_e(entity.func_70040_Z().func_186678_a(128.0));
            BlockRayTraceResult result = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
            this.targetPosition = result.func_216350_a();
        }
        MH5CloudEntity cloud = new MH5CloudEntity(entity.field_70170_p);
        cloud.setLife(100);
        cloud.func_174828_a(this.targetPosition, 0.0f, 0.0f);
        AbilityHelper.setDeltaMovement(cloud, 0.0, 0.0, 0.0);
        entity.field_70170_p.func_217376_c((Entity)cloud);
        this.cooldownComponent.startCooldown(entity, 1200.0f);
        this.targetPosition = null;
    }

    public void setTargetPosition(BlockPos targetPos) {
        this.targetPosition = targetPos;
    }

    private AbilityUseResult canUse(LivingEntity entity, IAbility ability) {
        if (MH5Ability.hasArmorSetEquipped(entity)) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail(null);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return false;
        }
        return MH5Ability.hasArmorSetEquipped(entity);
    }

    private static boolean hasArmorSetEquipped(LivingEntity entity) {
        ItemStack chestStack = entity.func_184582_a(EquipmentSlotType.CHEST);
        return !chestStack.func_190926_b() && chestStack.func_77973_b() == ModArmors.WOOTZ_STEEL_ARMOR.get();
    }
}

