/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.weapons.ModGunItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GunArrayAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gun_array", new Pair[]{ImmutablePair.of((Object)"While active it automatically fires bullets from the inventory.", null)});
    private static final int COOLDOWN = 40;
    public static final AbilityCore<GunArrayAbility> INSTANCE = new AbilityCore.Builder<GunArrayAbility>("Gun Array", AbilityCategory.EQUIPMENT, GunArrayAbility::new).addDescriptionLine(DESCRIPTION).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(GunArrayAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::triggerRepeaterEvent).addStopEvent(this::stopRepeaterEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private ItemStack bulletStack = ItemStack.field_190927_a;

    public GunArrayAbility(AbilityCore<GunArrayAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.repeaterComponent, this.projectileComponent);
        this.addCanUseCheck(this::canUse);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 20, 20);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.bulletStack.func_190926_b()) {
            this.findNewStack(entity);
            if (this.bulletStack.func_190926_b()) {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 40.0f);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        float innacuracy = 1.0f;
        if (entity.func_70051_ag()) {
            innacuracy = 3.0f;
        }
        if (entity.func_213453_ef()) {
            innacuracy = 0.0f;
        }
        this.projectileComponent.shoot(entity, 3.0f, innacuracy);
        this.bulletStack.func_190918_g(1);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        AbilityProjectileEntity proj = null;
        proj = this.bulletStack.func_77973_b() == ModItems.KAIROSEKI_BULLET.get() ? new KairosekiBulletProjectile(entity.field_70170_p, entity) : new NormalBulletProjectile(entity.field_70170_p, entity);
        double x = entity.func_226277_ct_() + WyHelper.randomWithRange(-1, 1) + WyHelper.randomDouble();
        double y = entity.func_226280_cw_() + WyHelper.randomDouble() / 2.0;
        double z = entity.func_226281_cx_() + WyHelper.randomWithRange(-1, 1) + WyHelper.randomDouble();
        proj.func_70012_b(x, y, z, 0.0f, 0.0f);
        return proj;
    }

    private void findNewStack(LivingEntity entity) {
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.get(i);
            if (stack == null || stack.func_190926_b() || !ModGunItem.GUN_AMMO.test(stack) || stack.func_190916_E() < 4) continue;
            this.bulletStack = stack;
            break;
        }
    }

    private AbilityUseResult canUse(LivingEntity entity, IAbility ability) {
        if (!GunArrayAbility.hasArmorSetEquipped(entity)) {
            return AbilityUseResult.fail(null);
        }
        this.findNewStack(entity);
        if (this.bulletStack.func_190926_b()) {
            return AbilityUseResult.fail(null);
        }
        return AbilityUseResult.success();
    }

    private static boolean canUnlock(LivingEntity entity) {
        return GunArrayAbility.hasArmorSetEquipped(entity);
    }

    private static boolean hasArmorSetEquipped(LivingEntity entity) {
        ItemStack chestStack = entity.func_184582_a(EquipmentSlotType.CHEST);
        return !chestStack.func_190926_b() && chestStack.func_77973_b() == ModArmors.WOOTZ_STEEL_ARMOR.get();
    }
}

