/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import journeymap.common.nbt.cache.CacheWorker;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;

public class CacheStorage
implements AutoCloseable {
    private final CacheWorker worker;

    public CacheStorage(Path file, boolean sync) {
        this.worker = new CacheWorker(file, sync);
    }

    @Nullable
    public CompoundNBT read(ChunkPos chunkPos) {
        try {
            return this.worker.load(chunkPos);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void write(ChunkPos chunkPos, CompoundNBT compoundTag) {
        this.worker.store(chunkPos, compoundTag);
    }

    public void flushWorker() {
        this.worker.synchronize(true).join();
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }
}

