/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.world.spawners;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartEntities;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.entities.ITrainer;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartTrainerSpawner {
    private static final Predicate<Entity> TRAINER_CHECK = target -> target instanceof ITrainer;
    private Random random = new Random();
    private int cooldown;

    public void tick(ServerWorld world) {
        world.func_217381_Z().func_76320_a("cartTrainerSpawnerTick");
        if (--this.cooldown <= 0) {
            this.cooldown = CommonConfig.INSTANCE.getTimeBetweenTrainerSpawns();
            if (this.random.nextInt(100) <= CommonConfig.INSTANCE.getChanceForTrainerSpawn()) {
                this.spawn(world);
            }
        }
        world.func_217381_Z().func_76319_b();
    }

    private void spawn(ServerWorld world) {
        world.func_217381_Z().func_76320_a("cartTrainerSpawnerTick");
        int listSize = MathHelper.func_76125_a((int)(world.func_217369_A().size() / 3), (int)1, (int)10);
        PlayerEntity[] cachedPlayers = new PlayerEntity[listSize];
        for (int i = 0; i < cachedPlayers.length; ++i) {
            boolean canSpawnInBiome;
            boolean alreadyCached;
            ServerPlayerEntity player = world.func_217472_l_();
            if (player == null || (alreadyCached = Arrays.stream(cachedPlayers).anyMatch(arg_0 -> CartTrainerSpawner.lambda$spawn$1((PlayerEntity)player, arg_0)))) continue;
            cachedPlayers[i] = player;
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            EntityType entityType = null;
            BlockPos targetPos = player.func_233580_cy_();
            Biome biome = world.func_226691_t_(targetPos);
            if (props.getFightingStyle().equals((Object)CartValues.BLUDGEON)) {
                entityType = (EntityType)CartEntities.BLUDGEON_TRAINER.get();
            } else if (props.getFightingStyle().equals((Object)CartValues.NITORYU)) {
                entityType = (EntityType)CartEntities.NITORYU_TRAINER.get();
            } else if (props.getFightingStyle().equals((Object)CartValues.RYUSOKEN)) {
                entityType = (EntityType)CartEntities.RYUSOKEN_TRAINER.get();
            }
            if (entityType == null) {
                return;
            }
            BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, (EntityType)entityType, (BlockPos)targetPos, (int)20);
            if (spawnPos == null) {
                return;
            }
            List trainers = WyHelper.getNearbyEntities((Vector3d)new Vector3d((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p()), (IWorld)world, (double)100.0, TRAINER_CHECK, (Class[])new Class[]{LivingEntity.class});
            boolean bl = canSpawnInBiome = biome.func_201856_r() != Biome.Category.OCEAN;
            if (trainers.size() >= 2 || !canSpawnInBiome) continue;
            entityType.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            WyDebug.debug((Object)("Trainer (" + entityType + ") spawned at: " + spawnPos));
        }
        world.func_217381_Z().func_76319_b();
    }

    private static /* synthetic */ boolean lambda$spawn$1(PlayerEntity player, PlayerEntity target) {
        return target == player;
    }
}

