/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.MrMagicalCart.cartaddon.models.morphs.LunarianClosedWingsModel;
import net.MrMagicalCart.cartaddon.models.morphs.LunarianOpenWingsModel;
import net.MrMagicalCart.cartaddon.models.morphs.LunarianWingModel;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class LunarianFeaturesLayer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final LunarianWingModel LUNARIAN_MODEL = new LunarianWingModel();
    private static final ResourceLocation LUNARIAN_TEXTURE = new ResourceLocation("cartaddon", "textures/models/zoanmorph/lunarian_wings.png");
    private static final LunarianOpenWingsModel LUNARIAN_OPEN_WINGS_MODEL = new LunarianOpenWingsModel();
    private static final ResourceLocation LUNARIAN_OPEN_WINGS_TEXTURE = new ResourceLocation("cartaddon", "textures/models/zoanmorph/lunarian_open_wings.png");
    private static final LunarianClosedWingsModel LUNARIAN_CLOSED_WINGS_MODEL = new LunarianClosedWingsModel();
    private static final ResourceLocation LUNARIAN_CLOSED_WINGS_TEXTURE = new ResourceLocation("cartaddon", "textures/models/zoanmorph/lunarian_closed_wings.png");
    public static final Map<String, Pair<BipedModel, ResourceLocation>> MAP;

    public LunarianFeaturesLayer(IEntityRenderer renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IEntityStats entityProps = EntityStatsCapability.get(entity);
        boolean isLunarian = entityProps.getRace().equals((Object)CartValues.LUNARIAN);
        boolean isInvisible = entity.func_70644_a(Effects.field_76441_p);
        if (isLunarian && !isInvisible) {
            BipedModel model = null;
            ResourceLocation res = null;
            if (entity instanceof PlayerEntity) {
                String uuid = entity.func_189512_bd();
                model = (BipedModel)MAP.get("lunarian_closed").getLeft();
                res = (ResourceLocation)MAP.get("lunarian_closed").getRight();
            }
            if (model != null && res != null) {
                ((BipedModel)this.func_215332_c()).func_217148_a(model);
                model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
                model.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.func_225598_a_(matrixStack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)res)), packedLight, LivingRenderer.func_229117_c_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    static {
        HashMap<String, Pair> map = new HashMap<String, Pair>();
        map.put("lunarian_closed", Pair.of((Object)((Object)LUNARIAN_CLOSED_WINGS_MODEL), (Object)LUNARIAN_CLOSED_WINGS_TEXTURE));
        MAP = Collections.unmodifiableMap(map);
    }
}

