/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.MrMagicalCart.cartaddon.models.morphs.FishGreatWhiteSharkModel;
import net.MrMagicalCart.cartaddon.models.morphs.FishOctoModel;
import net.MrMagicalCart.cartaddon.models.morphs.FishPointyNoseModel;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.config.AbilitiesConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class FishmanFeaturesLayer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final FishPointyNoseModel POINTY_NOSE_MODEL = new FishPointyNoseModel();
    private static final ResourceLocation POINTY_NOSE_TEXTURE = new ResourceLocation("cartaddon", "textures/models/zoanmorph/pointy_nose.png");
    private static final FishOctoModel OCTO_MODEL = new FishOctoModel();
    private static final ResourceLocation OCTO_TEXTURE = new ResourceLocation("cartaddon", "textures/models/zoanmorph/octo.png");
    private static final FishGreatWhiteSharkModel GREAT_WHITE_SHARK_MODEL = new FishGreatWhiteSharkModel();
    private static final ResourceLocation GREAT_WHITE_SHARK_TEXTURE = new ResourceLocation("cartaddon", "textures/models/zoanmorph/great_white_shark.png");
    public static final Map<String, Pair<BipedModel, ResourceLocation>> MAP;

    public FishmanFeaturesLayer(IEntityRenderer renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IEntityStats entityProps = EntityStatsCapability.get(entity);
        boolean isFishman = entityProps.isFishman();
        boolean isInvisible = entity.func_70644_a(Effects.field_76441_p);
        if (isFishman && !isInvisible) {
            BipedModel model = null;
            ResourceLocation res = null;
            String uuid = null;
            if (entity instanceof PlayerEntity) {
                uuid = entity.func_189512_bd();
                if (uuid.equals("7d0f81e8-a787-4cb5-ab74-485316ce741c")) {
                    model = (BipedModel)MAP.get("great_white_shark").getLeft();
                    res = (ResourceLocation)MAP.get("great_white_shark").getRight();
                } else if (AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC.get() != CommonConfig.HaoshokuUnlockLogic.TRUE_RANDOM && HakiHelper.isHaoshokuBorn((PlayerEntity)((PlayerEntity)entity))) {
                    model = (BipedModel)MAP.get("great_white_shark").getLeft();
                    res = (ResourceLocation)MAP.get("great_white_shark").getRight();
                } else if (uuid.indexOf(100) == -1) {
                    model = (BipedModel)MAP.get("octo").getLeft();
                    res = (ResourceLocation)MAP.get("octo").getRight();
                } else {
                    model = (BipedModel)MAP.get("pointy_nose").getLeft();
                    res = (ResourceLocation)MAP.get("pointy_nose").getRight();
                }
            }
            if (model != null && res != null) {
                ((BipedModel)this.func_215332_c()).func_217148_a(model);
                model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
                model.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.func_225598_a_(matrixStack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)res)), packedLight, LivingRenderer.func_229117_c_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    static {
        HashMap<String, Pair> map = new HashMap<String, Pair>();
        map.put("pointy_nose", Pair.of((Object)((Object)POINTY_NOSE_MODEL), (Object)POINTY_NOSE_TEXTURE));
        map.put("octo", Pair.of((Object)((Object)OCTO_MODEL), (Object)OCTO_TEXTURE));
        map.put("great_white_shark", Pair.of((Object)((Object)GREAT_WHITE_SHARK_MODEL), (Object)GREAT_WHITE_SHARK_TEXTURE));
        MAP = Collections.unmodifiableMap(map);
    }
}

