/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.quests.twinbarrel;

import net.MrMagicalCart.cartaddon.abilities.twinbarrel.JumpShotsAbility;
import net.MrMagicalCart.cartaddon.abilities.twinbarrel.SpinningBarrelShotsAbility;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;

public class TwinBarrelTrial03Quest
extends Quest {
    public static final QuestId INSTANCE;
    private Objective objective01 = new KillEntityObjective("Kill %s enemies using Spinning Barrel Shots", 30, SharedKillChecks.HAS_BOW.and(SPINNING_BARREL_SHOTS_CHECK));
    private Objective objective02 = new KillEntityObjective("Kill %s enemies with jump shots", 10, JUMPSHOT_CHECK);
    private static final KillEntityObjective.ICheckKill SPINNING_BARREL_SHOTS_CHECK;
    private static final KillEntityObjective.ICheckKill JUMPSHOT_CHECK;

    public TwinBarrelTrial03Quest(QuestId id) {
        super(id);
        this.addObjectives(new Objective[]{this.objective01, this.objective02});
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(JumpShotsAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }

    static {
        JUMPSHOT_CHECK = (player, target, source) -> {
            ItemStack heldItem = player.func_184614_ca();
            return ItemsHelper.isBow((ItemStack)heldItem) && !player.func_233570_aj_();
        };
        INSTANCE = new QuestId.Builder("Trial: Jump Shots", TwinBarrelTrial03Quest::new).addRequirements(new QuestId[]{CartQuests.TWIN_BARREL_TRIAL_02}).build();
        SPINNING_BARREL_SHOTS_CHECK = (player, target, source) -> source instanceof AbilityDamageSource && ((AbilityDamageSource)source).getAbilitySource().equals(SpinningBarrelShotsAbility.INSTANCE);
    }
}

