/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.quests.swordsmanextra;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.swordsmenextra.ReworkedShiShishiSonsonAbility;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;

public class SwordsmanTrial01Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Shi Shishi Sonson", SwordsmanTrial01Quest::new).build();
    private static final Predicate<ItemStack> ITEM_OVER_7_DAMAGE = itemStack -> ItemsHelper.isSword((ItemStack)itemStack) && ItemsHelper.getItemDamage((ItemStack)itemStack) > 7.0f;
    private Objective objective01 = new ObtainItemObjective("Obtain a sword with over 7 damage", 1, ITEM_OVER_7_DAMAGE);
    private Objective objective02 = new ObtainItemObjective("Collect %s bones", 25, () -> Items.field_151103_aS).addRequirement(this.objective01);
    private Objective objective03 = new KillEntityObjective("Kill %s enemies using a sword", 20, SharedKillChecks.HAS_SWORD).addRequirement(this.objective01);

    public SwordsmanTrial01Quest(QuestId id) {
        super(id);
        this.addObjectives(new Objective[]{this.objective01, this.objective02, this.objective03});
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, Items.field_151103_aS, 25)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(ReworkedShiShishiSonsonAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

