/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.quests.sniperextra;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.sniperextra.GunBashAbility;
import net.MrMagicalCart.cartaddon.abilities.sniperextra.ReworkedHiNoToriBoshiAbility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KujaArrowProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.PopGreenProjectile;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;

public class SniperTrial01Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Hi no Tori Boshi & Gun Bash", SniperTrial01Quest::new).build();
    private static final Predicate<ItemStack> ITEM_IS_BOW = itemStack -> ItemsHelper.isBow((ItemStack)itemStack);
    private static final KillEntityObjective.ICheckKill BOW_DISTANCE_CHECK = (player, target, source) -> {
        ItemStack heldItem = player.func_184614_ca();
        boolean isBow = ItemsHelper.isBow((ItemStack)heldItem);
        boolean isArrow = source.func_76364_f() instanceof ArrowEntity || source.func_76364_f() instanceof KujaArrowProjectile || source.func_76364_f() instanceof PopGreenProjectile;
        boolean distance = player.func_70032_d((Entity)target) >= 30.0f;
        return isBow && isArrow && distance;
    };
    private Objective objective01 = new ObtainItemObjective("Obtain a bow", 1, ITEM_IS_BOW);
    private Objective objective02 = new ObtainItemObjective("Collect %s strings", 15, () -> Items.field_151007_F).addRequirement(this.objective01);
    private Objective objective03 = new KillEntityObjective("Kill %s enemies from at least 30 blocks away using a bow", 3, BOW_DISTANCE_CHECK).addRequirement(this.objective01);

    public SniperTrial01Quest(QuestId id) {
        super(id);
        this.addObjectives(new Objective[]{this.objective01, this.objective02, this.objective03});
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, Items.field_151007_F, 15)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(ReworkedHiNoToriBoshiAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        props.addUnlockedAbility(GunBashAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

