/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.quests.brawlerextra;

import net.MrMagicalCart.cartaddon.abilities.brawlerextra.QueenPunchAbility;
import net.MrMagicalCart.cartaddon.abilities.brawlerextra.ReworkedJishinHoAbility;
import net.MrMagicalCart.cartaddon.abilities.brawlerextra.ReworkedSuplexAbility;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;
import xyz.pixelatedw.mineminenomi.quests.objectives.TimedKillEntityObjective;

public class BrawlerTrial06Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Queen Punch", BrawlerTrial06Quest::new).addRequirements(new QuestId[]{CartQuests.BRAWLER_TRIAL_04, CartQuests.BRAWLER_TRIAL_05}).build();
    private Objective objective01;
    private Objective objective02;
    private Objective objective03;

    public BrawlerTrial06Quest(QuestId id) {
        super(id);
        this.objective01 = new KillEntityObjective("Kill %s enemies using Suplex", 10, SharedKillChecks.checkAbilitySource(ReworkedSuplexAbility.INSTANCE)).addRequirement(this.objective01);
        this.objective02 = new TimedKillEntityObjective("Kill %s enemies using Jishin Ho in %s seconds or less", 5, 5, SharedKillChecks.checkAbilitySource(ReworkedJishinHoAbility.INSTANCE));
        this.objective03 = new KillEntityObjective("Kill %s enemies using your fists while they're in air", 3, SharedKillChecks.HAS_EMPTY_HAND.and(SharedKillChecks.AIRBORNE_ENEMY_CHECK));
        this.addObjectives(new Objective[]{this.objective01, this.objective02, this.objective03});
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(QueenPunchAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

