/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.quests.bludgeon;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.bludgeon.StrikingSwingAbility;
import net.MrMagicalCart.cartaddon.quests.objectives.CartSharedKillChecks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;

public class BludgeonTrial01Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Striking Swing", BludgeonTrial01Quest::new).build();
    private static final Predicate<ItemStack> ITEM = itemStack -> ItemsHelper.isBlunt((ItemStack)itemStack);
    private Objective objective01 = new ObtainItemObjective("Obtain a Mace", 1, ITEM);
    private Objective objective02 = new ObtainItemObjective("Collect %s glass bottles", 9, () -> Items.field_151069_bo).addRequirement(this.objective01);
    private Objective objective03 = new KillEntityObjective("Kill %s enemies with a Mace", 10, CartSharedKillChecks.HAS_BLUNT).addRequirement(this.objective01);

    public BludgeonTrial01Quest(QuestId id) {
        super(id);
        this.addObjectives(new Objective[]{this.objective01, this.objective02, this.objective03});
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, Items.field_151069_bo, 9)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(StrikingSwingAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

