/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.mixins;

import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.marineloyalty.PacifistaReinforcementsAbility;
import net.MrMagicalCart.cartaddon.abilities.revloyalty.RallyingFlagAbility;
import net.MrMagicalCart.cartaddon.init.CartFactions;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.charactercreator.CharacterCreatorSelectionMap;
import xyz.pixelatedw.mineminenomi.api.charactercreator.FactionId;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

@Mixin(value={WyRegistry.class})
public abstract class RegisterFactionMixin {
    @Shadow
    @Final
    public static DeferredRegister<FactionId> FACTIONS;

    @Inject(method={"registerFaction"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static <I extends FactionId> void registerEditedFaction(String localizedName, Supplier<I> faction, CallbackInfoReturnable<RegistryObject<I>> cir) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        Supplier<Object> modifiedFaction = faction;
        if (resourceName.equalsIgnoreCase("marine")) {
            modifiedFaction = () -> {
                FactionId id = (FactionId)faction.get();
                CharacterCreatorSelectionMap.SelectionInfo info = id.getInfo();
                info.addTopAbilities(new AbilityCore[]{PacifistaReinforcementsAbility.INSTANCE});
                return id;
            };
        }
        if (resourceName.equalsIgnoreCase("bounty_hunter")) {
            modifiedFaction = () -> {
                FactionId id = (FactionId)faction.get();
                CharacterCreatorSelectionMap.SelectionInfo info = id.getInfo();
                info.addBottomAbilities(new AbilityCore[]{CartFactions.BLACK_MARKET_PERK});
                return id;
            };
        }
        cir.setReturnValue((Object)WyRegistry.registerFaction((String)resourceName, (String)localizedName, modifiedFaction));
    }

    @Inject(method={"registerFaction(Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Supplier;)Lnet/minecraftforge/fml/RegistryObject;"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static <I extends FactionId> void registerEditedFaction2(String id, String localizedName, Supplier<I> faction, CallbackInfoReturnable<RegistryObject<I>> cir) {
        WyRegistry.getLangMap().put("faction.mineminenomi." + id, localizedName);
        Supplier<Object> modifiedFaction = faction;
        if (id.equalsIgnoreCase("revolutionary")) {
            modifiedFaction = () -> {
                FactionId factionId = (FactionId)faction.get();
                CharacterCreatorSelectionMap.SelectionInfo info = factionId.getInfo();
                info.addTopAbilities(new AbilityCore[]{RallyingFlagAbility.INSTANCE});
                info.addBottomAbilities(new AbilityCore[]{CartFactions.BLACK_MARKET_PERK});
                return factionId;
            };
        }
        RegistryObject reg = FACTIONS.register(id, modifiedFaction);
        cir.setReturnValue((Object)reg);
    }
}

