/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.init;

import com.google.common.base.Strings;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.MrMagicalCart.cartaddon.init.CartWeapons;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.gasu.BlueSwordAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.CurrencyHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.events.devilfruits.RandomFruitEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartItemModelProps {
    public static final IItemPropertyGetter BLUE_GORO = (itemStack, world, livingEntity) -> {
        if (CommonConfig.INSTANCE.getRandomizedFruits()) {
            return 0.0f;
        }
        return ClientConfig.INSTANCE.isGoroBlue() ? 1.0f : 0.0f;
    };
    public static final IItemPropertyGetter BELLY_POUCH_SIZE = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        long belly = itemStack.func_196082_o().func_74763_f("belly");
        int size = 0;
        if (belly > 1000L && belly < 5000L) {
            size = 1;
        } else if (belly >= 5000L) {
            size = 2;
        }
        return size;
    };
    public static final IItemPropertyGetter EXTOL_POUCH_SIZE = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        long extol = itemStack.func_196082_o().func_74763_f("extol");
        long belly = CurrencyHelper.getBellyFromExtol((long)extol);
        int size = 0;
        if (belly > 1000L && belly < 5000L) {
            size = 1;
        } else if (belly >= 5000L) {
            size = 2;
        }
        return size;
    };
    public static final IItemPropertyGetter DEVIL_FRUITS_RANDOMIZER = (itemStack, world, livingEntity) -> {
        if (itemStack != null && !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof AkumaNoMiItem) {
            if (!RandomFruitEvents.Client.HAS_RANDOMIZED_FRUIT) {
                AkumaNoMiItem fruit = (AkumaNoMiItem)itemStack.func_77973_b();
                fruit.removeBaseColor(itemStack);
                fruit.removeStemColor(itemStack);
                return -1.0f;
            }
            if (world == null && livingEntity != null) {
                world = (ClientWorld)livingEntity.field_70170_p;
            }
            ((AkumaNoMiItem)itemStack.func_77973_b()).applyRandomness((World)world, itemStack);
            return itemStack.func_196082_o().func_74762_e("type");
        }
        return 1.0f;
    };
    public static final IItemPropertyGetter SAKE_CUP_FILLED = (itemStack, world, livingEntity) -> itemStack.func_77978_p() != null && !Strings.isNullOrEmpty((String)itemStack.func_77978_p().func_74779_i("leader")) ? 1.0f : 0.0f;
    public static final IItemPropertyGetter SHEATHED_WEAPON = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 1.0f;
        }
        boolean mainHandFlag = ItemStack.func_179545_c((ItemStack)livingEntity.func_184614_ca(), (ItemStack)itemStack);
        boolean offHandFlag = ItemStack.func_179545_c((ItemStack)livingEntity.func_184592_cb(), (ItemStack)itemStack);
        IEntityStats props = EntityStatsCapability.get((LivingEntity)livingEntity);
        if (livingEntity instanceof PlayerEntity && props.getFightingStyle().equals((Object)CartValues.NITORYU) && props.isSniper()) {
            ItemStack stack = ((PlayerEntity)livingEntity).field_71071_by.func_70301_a(0);
            boolean firstSlotFlag = ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemStack);
            return !mainHandFlag && !offHandFlag && !firstSlotFlag ? 1.0f : 0.0f;
        }
        return !mainHandFlag && !offHandFlag ? 1.0f : 0.0f;
    };
    public static final IItemPropertyGetter HAKI_WEAPON = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        float hasHakiActive = 0.0f;
        if (livingEntity instanceof PlayerEntity) {
            boolean mainHandFlag = livingEntity.func_184614_ca() == itemStack;
            boolean offHandFlag = livingEntity.func_184592_cb() == itemStack;
            boolean hakiActiveFlag = HakiHelper.hasImbuingActive((LivingEntity)livingEntity);
            hasHakiActive = (mainHandFlag || offHandFlag) && hakiActiveFlag ? 1.0f : 0.0f;
            IEntityStats props = EntityStatsCapability.get((LivingEntity)livingEntity);
            if (livingEntity instanceof PlayerEntity && props.getFightingStyle().equals((Object)CartValues.NITORYU) && props.isSniper()) {
                ItemStack stack = ((PlayerEntity)livingEntity).field_71071_by.func_70301_a(0);
                boolean firstSlotFlag = stack == itemStack;
                hasHakiActive = (mainHandFlag || offHandFlag || firstSlotFlag) && hakiActiveFlag ? 1.0f : 0.0f;
            }
        } else if (livingEntity instanceof OPEntity) {
            hasHakiActive = ((OPEntity)livingEntity).hasBusoHaki() ? 1.0f : 0.0f;
        }
        return hasHakiActive;
    };
    public static final IItemPropertyGetter UMBRELLA_OPEN = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        boolean mainHandFlag = livingEntity.func_184614_ca() == itemStack;
        boolean offHandFlag = livingEntity.func_184592_cb() == itemStack;
        boolean isInAir = !livingEntity.func_233570_aj_() && livingEntity.func_213322_ci().field_72448_b < 0.0;
        BlockPos blockpos = livingEntity.func_233580_cy_();
        boolean isRaining = livingEntity.field_70170_p.func_175727_C(blockpos) || livingEntity.field_70170_p.func_175727_C(new BlockPos((double)blockpos.func_177958_n(), livingEntity.func_174813_aQ().field_72337_e, (double)blockpos.func_177952_p()));
        boolean checkMainHand = !livingEntity.func_184614_ca().func_190926_b() && livingEntity.func_184614_ca().func_77973_b() == ModWeapons.UMBRELLA.get();
        boolean checkOffHand = !livingEntity.func_184592_cb().func_190926_b() && livingEntity.func_184592_cb().func_77973_b() == ModWeapons.UMBRELLA.get();
        boolean holdsUmbrella = checkMainHand || checkOffHand;
        return (!mainHandFlag && !offHandFlag || !isInAir) && (!isRaining || !holdsUmbrella) ? 0.0f : 1.0f;
    };
    public static final IItemPropertyGetter BLUE_SWORD_WEAPON = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 1.0f;
        }
        boolean mainHandFlag = ItemStack.func_179545_c((ItemStack)livingEntity.func_184614_ca(), (ItemStack)itemStack);
        boolean offHandFlag = ItemStack.func_179545_c((ItemStack)livingEntity.func_184592_cb(), (ItemStack)itemStack);
        boolean hasAbl = AbilityDataCapability.get((LivingEntity)livingEntity).hasUnlockedAbility(BlueSwordAbility.INSTANCE);
        return (mainHandFlag || offHandFlag) && hasAbl ? 0.0f : 1.0f;
    };
    public static final IItemPropertyGetter PULL = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        return livingEntity.func_184607_cu() != itemStack ? 0.0f : (float)(itemStack.func_77988_m() - livingEntity.func_184605_cv()) / 20.0f;
    };
    public static final IItemPropertyGetter PULLING = (itemStack, world, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack ? 1.0f : 0.0f;
    public static final IItemPropertyGetter LOLLIPOP = (itemStack, world, livingEntity) -> WyHelper.isAprilFirst() ? 1.0f : 0.0f;

    public static void register() {
        for (AkumaNoMiItem df : ModValues.DEVIL_FRUITS) {
            ItemModelsProperties.func_239418_a_((Item)df, (ResourceLocation)new ResourceLocation("type"), (IItemPropertyGetter)DEVIL_FRUITS_RANDOMIZER);
        }
        ItemModelsProperties.func_239418_a_((Item)ModAbilities.GORO_GORO_NO_MI, (ResourceLocation)new ResourceLocation("alt_texture"), (IItemPropertyGetter)BLUE_GORO);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.BELLY_POUCH.get()), (ResourceLocation)new ResourceLocation("size"), (IItemPropertyGetter)BELLY_POUCH_SIZE);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.EXTOL_POUCH.get()), (ResourceLocation)new ResourceLocation("size"), (IItemPropertyGetter)EXTOL_POUCH_SIZE);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.SAKE_CUP.get()), (ResourceLocation)new ResourceLocation("filled"), (IItemPropertyGetter)SAKE_CUP_FILLED);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.UMBRELLA.get()), (ResourceLocation)new ResourceLocation("open"), (IItemPropertyGetter)UMBRELLA_OPEN);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SORCERY_CLIMA_TACT.get()), (ResourceLocation)new ResourceLocation("open"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.GREEN_KUJA_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)PULL);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.GREEN_KUJA_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)PULLING);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.KABUTO.get()), (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)PULL);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.KABUTO.get()), (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)PULLING);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.BLACK_KABUTO.get()), (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)PULL);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.BLACK_KABUTO.get()), (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)PULLING);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.GINGA_PACHINKO.get()), (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)PULL);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.GINGA_PACHINKO.get()), (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)PULLING);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.MARINE_SWORD.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.MARINE_SWORD.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.PIRATE_CUTLASS.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.PIRATE_CUTLASS.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.PIPE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SCISSORS.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.KIKOKU.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.KIKOKU.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.KIRIBACHI.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.YORU.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.MURAKUMOGIRI.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.HOOK.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.HOOK.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.JITTE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.NONOSAMA_STAFF.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.NONOSAMA_TRIDENT.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.HAMMER_5T.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.TONFA.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.BANDIT_KNIFE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.ACES_KNIFE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.MIHAWKS_KNIFE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.MIHAWKS_KNIFE.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SANDAI_KITETSU.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SANDAI_KITETSU.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.WADO_ICHIMONJI.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.WADO_ICHIMONJI.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.NIDAI_KITETSU.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.NIDAI_KITETSU.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SHUSUI.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SHUSUI.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.ENMA.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.ENMA.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.AME_NO_HABAKIRI.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.AME_NO_HABAKIRI.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SOUL_SOLID.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SOUL_SOLID.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.DURANDAL.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.DURANDAL.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.MACE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.DAISENSO.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.MOGURA.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.DALTONS_SPADE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.ACE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.BLUE_SWORD.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)BLUE_SWORD_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.AXE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SPEAR.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.KATANA.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.DAGGER.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.CUTLASS.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.BROADSWORD.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.BISENTO.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.CLEAVER.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.HASSAIKAI.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.GRYPHON.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.SAMEKIRI_BOCHO.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModWeapons.CHAKRAM.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        if (WyHelper.isAprilFirst()) {
            ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.CIGAR.get()), (ResourceLocation)new ResourceLocation("april"), (IItemPropertyGetter)LOLLIPOP);
            ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.CIGARETTE.get()), (ResourceLocation)new ResourceLocation("april"), (IItemPropertyGetter)LOLLIPOP);
            ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.SMOKING_PIPE.get()), (ResourceLocation)new ResourceLocation("april"), (IItemPropertyGetter)LOLLIPOP);
            ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.THREE_CIGARS.get()), (ResourceLocation)new ResourceLocation("april"), (IItemPropertyGetter)LOLLIPOP);
        }
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.GOLDEN_TONFA.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.GORU_AXE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SHIGURE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SHIGURE.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SHINKO_KITETSI.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SHINKO_KITETSI.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.ROGERS_ACE.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.ROGERS_ACE.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.FALSE_YORU.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.YUBASHIRI.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.YUBASHIRI.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.YAKUZA_KASEN.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.YAKUZA_KASEN.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SUKESAN.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SUKESAN.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.KAKUSAN.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.KAKUSAN.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.RAYU_SHIRU.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.RAYU_SHIRU.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SHODAI_KITETSU.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SHODAI_KITETSU.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SOTO_MUSO.get()), (ResourceLocation)new ResourceLocation("haki"), (IItemPropertyGetter)HAKI_WEAPON);
        ItemModelsProperties.func_239418_a_((Item)((Item)CartWeapons.SOTO_MUSO.get()), (ResourceLocation)new ResourceLocation("sheathed"), (IItemPropertyGetter)SHEATHED_WEAPON);
    }
}

