/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.api.helpers.CartMobsHelper;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.mobs.CartCommanderEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.CartGruntEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.CartOfficerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.PacifistaMarkTwoEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.SBearEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.SHawkEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.SSnakeEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.SmokerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.misc.BlackMarketTraderEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.AdvancedBlackLegTrainerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.AdvancedBrawlerTrainerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.AdvancedSwordsmanTrainerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.BludgeonTrainerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.NitoryuTrainerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.RyusokenTrainerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.TwinBarrelTrainerEntity;
import net.MrMagicalCart.cartaddon.entities.mobs.rev.SaboEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.config.WorldEventsConfig;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CartEntities {
    public static final ArrayList<BiomeDictionary.Type> REV_BIOMES;
    public static final EntityClassification REVS;
    public static final RegistryObject<EntityType<BludgeonTrainerEntity>> BLUDGEON_TRAINER;
    public static final RegistryObject<EntityType<NitoryuTrainerEntity>> NITORYU_TRAINER;
    public static final RegistryObject<EntityType<RyusokenTrainerEntity>> RYUSOKEN_TRAINER;
    public static final RegistryObject<EntityType<AdvancedBrawlerTrainerEntity>> A_BRAWLER_TRAINER;
    public static final RegistryObject<EntityType<AdvancedSwordsmanTrainerEntity>> A_SWORDSMAN_TRAINER;
    public static final RegistryObject<EntityType<AdvancedBlackLegTrainerEntity>> A_BLACKLEG_TRAINER;
    public static final RegistryObject<EntityType<BlackMarketTraderEntity>> BLACK_MARKET_TRADER;
    public static final RegistryObject<EntityType<CartGruntEntity>> REV_GRUNTS;
    public static final RegistryObject<EntityType<CartOfficerEntity>> REV_OFFICERS;
    public static final RegistryObject<EntityType<CartCommanderEntity>> REV_COMMANDERS;
    public static final RegistryObject<EntityType<PacifistaMarkTwoEntity>> PACIFISTA_TWO;
    public static final RegistryObject<EntityType<SmokerEntity>> SMOKER;
    public static final RegistryObject<EntityType<TwinBarrelTrainerEntity>> TWIN_BARREL_TRAINER;
    public static final RegistryObject<EntityType<SSnakeEntity>> SSNAKE;
    public static final RegistryObject<EntityType<SHawkEntity>> SHAWK;
    public static final RegistryObject<EntityType<SaboEntity>> SABO;
    public static final RegistryObject<EntityType<SBearEntity>> SBEAR;

    private static <T extends Entity> RegistryObject<EntityType<T>> registerFactionlessWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = CartRegistry.registerEntityType(name, supp);
        CartRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, WyHelper.hexToRGB((String)"#fbbf4c").getRGB(), WyHelper.hexToRGB((String)"#F7F7F7").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerMarineWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = CartRegistry.registerEntityType(name, supp);
        CartRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, WyHelper.hexToRGB((String)"#024a81").getRGB(), WyHelper.hexToRGB((String)"#F7F7F7").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerRevWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = CartRegistry.registerEntityType(name, supp);
        CartRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, CartMobsHelper.REV_COLORS.getRGB(), WyHelper.hexToRGB((String)"#F7F7F7").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)BLUDGEON_TRAINER.get(), BludgeonTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)NITORYU_TRAINER.get(), NitoryuTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)RYUSOKEN_TRAINER.get(), RyusokenTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)A_BRAWLER_TRAINER.get(), AdvancedBrawlerTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)A_SWORDSMAN_TRAINER.get(), AdvancedSwordsmanTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)A_BLACKLEG_TRAINER.get(), AdvancedBlackLegTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BLACK_MARKET_TRADER.get(), BlackMarketTraderEntity.createAttributes().func_233813_a_());
        event.put((EntityType)REV_GRUNTS.get(), CartGruntEntity.createAttributes().func_233813_a_());
        event.put((EntityType)REV_OFFICERS.get(), CartOfficerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)REV_COMMANDERS.get(), CartCommanderEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PACIFISTA_TWO.get(), PacifistaMarkTwoEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SMOKER.get(), SmokerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)TWIN_BARREL_TRAINER.get(), TwinBarrelTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SSNAKE.get(), SSnakeEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SHAWK.get(), SHawkEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SABO.get(), SaboEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SBEAR.get(), SBearEntity.createAttributes().func_233813_a_());
    }

    public static void setupSpawnRules() {
        if (((Boolean)WorldEventsConfig.SPAWN_WORLD_HUMANOIDS.get()).booleanValue()) {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)REV_GRUNTS.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CartGruntEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)REV_OFFICERS.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CartOfficerEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)REV_COMMANDERS.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CartCommanderEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PACIFISTA_TWO.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PacifistaMarkTwoEntity::checkSpawnRules);
        }
    }

    public static void setupCategorySpawns(BiomeLoadingEvent event) {
        if (event.getName() != null) {
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
            Set types = BiomeDictionary.getTypes((RegistryKey)key);
            if (((Boolean)WorldEventsConfig.SPAWN_WORLD_HUMANOIDS.get()).booleanValue()) {
                if (REV_BIOMES.stream().anyMatch(type -> types.contains(type))) {
                    event.getSpawns().func_242575_a(REVS, new MobSpawnInfo.Spawners((EntityType)REV_GRUNTS.get(), 10, 2, 5)).func_242577_b();
                    event.getSpawns().func_242575_a(REVS, new MobSpawnInfo.Spawners((EntityType)REV_OFFICERS.get(), 2, 1, 3)).func_242577_b();
                    event.getSpawns().func_242575_a(REVS, new MobSpawnInfo.Spawners((EntityType)REV_COMMANDERS.get(), 1, 1, 2)).func_242577_b();
                }
                if (ModEntities.MARINE_BIOMES.stream().anyMatch(type -> types.contains(type))) {
                    event.getSpawns().func_242575_a(ModEntities.MARINES, new MobSpawnInfo.Spawners((EntityType)PACIFISTA_TWO.get(), 1, 1, 1)).func_242577_b();
                }
            }
        }
    }

    public static void register(IEventBus eventBus) {
        CartRegistry.ENTITY_TYPES.register(eventBus);
    }

    static {
        REVS = EntityClassification.create((String)"revolutionaries", (String)"revolutionaries", (int)25, (boolean)false, (boolean)true, (int)128);
        REV_BIOMES = Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MESA});
        BLUDGEON_TRAINER = CartEntities.registerFactionlessWithSpawnEgg("Bludgeon Trainer", () -> CartRegistry.createEntityType(BludgeonTrainerEntity::new).func_206830_a("cartaddon:bludgeon_trainer"));
        NITORYU_TRAINER = CartEntities.registerFactionlessWithSpawnEgg("Nitoryu Trainer", () -> CartRegistry.createEntityType(NitoryuTrainerEntity::new).func_206830_a("cartaddon:nitoryu_trainer"));
        RYUSOKEN_TRAINER = CartEntities.registerFactionlessWithSpawnEgg("Ryusoken Trainer", () -> CartRegistry.createEntityType(RyusokenTrainerEntity::new).func_206830_a("cartaddon:ryusoken_trainer"));
        A_BRAWLER_TRAINER = CartEntities.registerFactionlessWithSpawnEgg("Advanced Brawler Trainer", () -> CartRegistry.createEntityType(AdvancedBrawlerTrainerEntity::new).func_206830_a("cartaddon:advanced_brawler_trainer"));
        A_SWORDSMAN_TRAINER = CartEntities.registerFactionlessWithSpawnEgg("Advanced Swordsman Trainer", () -> CartRegistry.createEntityType(AdvancedSwordsmanTrainerEntity::new).func_206830_a("cartaddon:advanced_swordsman_trainer"));
        A_BLACKLEG_TRAINER = CartEntities.registerFactionlessWithSpawnEgg("Advanced Black Leg Trainer", () -> CartRegistry.createEntityType(AdvancedBlackLegTrainerEntity::new).func_206830_a("cartaddon:advanced_black_leg_trainer"));
        BLACK_MARKET_TRADER = CartEntities.registerFactionlessWithSpawnEgg("Black Market Trader", () -> CartRegistry.createEntityType(BlackMarketTraderEntity::new).func_206830_a("cartaddon:black_market_trader"));
        REV_GRUNTS = CartEntities.registerRevWithSpawnEgg("Revolutionary Army Grunt", () -> CartRegistry.createEntityType(CartGruntEntity::createRevolutionaryGrunt, REVS).func_206830_a("cartaddon:revolutionary_army_grunt"));
        REV_OFFICERS = CartEntities.registerRevWithSpawnEgg("Revolutionary Army Officer", () -> CartRegistry.createEntityType(CartOfficerEntity::createRevolutionaryOfficer, REVS).func_206830_a("cartaddon:revolutionary_army_officer"));
        REV_COMMANDERS = CartEntities.registerRevWithSpawnEgg("Revolutionary Army Commander", () -> CartRegistry.createEntityType(CartCommanderEntity::createRevolutionaryCommader, REVS).func_206830_a("cartaddon:revolutionary_army_commander"));
        PACIFISTA_TWO = CartEntities.registerMarineWithSpawnEgg("Pacifista Mark Two", () -> CartRegistry.createEntityType(PacifistaMarkTwoEntity::new).func_220320_c().func_220321_a(1.5f, 3.75f).func_206830_a("cartaddon:pacifista_mark_two"));
        SMOKER = CartRegistry.registerEntityType("Smoker", () -> CartRegistry.createEntityType(SmokerEntity::new, ModEntities.MARINES).func_220321_a(0.6f, 2.0f).func_206830_a("cartaddon:smoker"));
        TWIN_BARREL_TRAINER = CartEntities.registerFactionlessWithSpawnEgg("Twin Barrel Trainer", () -> CartRegistry.createEntityType(TwinBarrelTrainerEntity::new).func_206830_a("cartaddon:twin_barrel_trainer"));
        SSNAKE = CartRegistry.registerEntityType("S Snake", () -> CartRegistry.createEntityType(SSnakeEntity::new, ModEntities.MARINES).func_206830_a("cartaddon:s_snake"));
        SHAWK = CartRegistry.registerEntityType("S Hawk", () -> CartRegistry.createEntityType(SHawkEntity::new, ModEntities.MARINES).func_206830_a("cartaddon:s_hawk"));
        SABO = CartRegistry.registerEntityType("Sabo", () -> CartRegistry.createEntityType(SaboEntity::new, REVS).func_206830_a("cartaddon:sabo"));
        SBEAR = CartRegistry.registerEntityType("S Bear", () -> CartRegistry.createEntityType(SBearEntity::new, ModEntities.MARINES).func_220321_a(0.8f, 2.3f).func_206830_a("cartaddon:s_bear"));
    }
}

