/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.events;

import java.util.List;
import java.util.Random;
import net.MrMagicalCart.cartaddon.init.CartEntities;
import net.MrMagicalCart.cartaddon.world.spawners.CartTraderSpawner;
import net.MrMagicalCart.cartaddon.world.spawners.CartTrainerSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;

@Mod.EventBusSubscriber(modid="cartaddon")
public class CartWorldEvents {
    private static final CartTrainerSpawner TRAINER_SPAWNER = new CartTrainerSpawner();
    private static final CartTraderSpawner TRADER_SPAWNER = new CartTraderSpawner();

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.world.func_234923_W_() == World.field_234918_g_ && event.world.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
            event.world.func_217381_Z().func_76320_a("cartWorldSpawners");
            if (CommonConfig.INSTANCE.canSpawnTraders()) {
                TRADER_SPAWNER.tick((ServerWorld)event.world);
            }
            if (CommonConfig.INSTANCE.canSpawnTrainers()) {
                TRAINER_SPAWNER.tick((ServerWorld)event.world);
            }
        }
    }

    public static final void spawnOPChunkEntities(IServerWorld world, Biome biome, int chunkX, int chunkZ, Random rand) {
        CartWorldEvents.spawnMobsForChunkGeneration(world, biome, chunkX, chunkZ, rand, CartEntities.REVS);
    }

    private static void spawnMobsForChunkGeneration(IServerWorld world, Biome biome, int chunkX, int chunkZ, Random rand, EntityClassification category) {
        MobSpawnInfo mobspawninfo = biome.func_242433_b();
        List list = mobspawninfo.func_242559_a(category);
        if (!list.isEmpty()) {
            int x = chunkX << 4;
            int z = chunkZ << 4;
            while (rand.nextFloat() < mobspawninfo.func_242557_a()) {
                MobSpawnInfo.Spawners spawners = (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)rand, (List)list);
                int k = spawners.field_242589_d + rand.nextInt(1 + spawners.field_242590_e - spawners.field_242589_d);
                ILivingEntityData ilivingentitydata = null;
                int l = x + rand.nextInt(16);
                int i1 = z + rand.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockpos = CartWorldEvents.getTopNonCollidingPos((IWorldReader)world, spawners.field_242588_c, l, i1);
                        if (spawners.field_242588_c.func_200720_b() && WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)spawners.field_242588_c), (IWorldReader)world, (BlockPos)blockpos, (EntityType)spawners.field_242588_c)) {
                            Entity entity;
                            float f = spawners.field_242588_c.func_220333_h();
                            double d0 = MathHelper.func_151237_a((double)l, (double)((double)x + (double)f), (double)((double)x + 16.0 - (double)f));
                            double d1 = MathHelper.func_151237_a((double)i1, (double)((double)z + (double)f), (double)((double)z + 16.0 - (double)f));
                            if (!world.func_226664_a_(spawners.field_242588_c.func_220328_a(d0, (double)blockpos.func_177956_o(), d1)) || !EntitySpawnPlacementRegistry.func_223515_a((EntityType)spawners.field_242588_c, (IServerWorld)world, (SpawnReason)SpawnReason.CHUNK_GENERATION, (BlockPos)new BlockPos(d0, (double)blockpos.func_177956_o(), d1), (Random)world.func_201674_k())) continue;
                            try {
                                entity = spawners.field_242588_c.func_200721_a((World)world.func_201672_e());
                            }
                            catch (Exception var28) {
                                continue;
                            }
                            entity.func_70012_b(d0, (double)blockpos.func_177956_o(), d1, rand.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof MobEntity) {
                                MobEntity mobentity = (MobEntity)entity;
                                if (ForgeHooks.canEntitySpawn((MobEntity)mobentity, (IWorld)world, (double)d0, (double)blockpos.func_177956_o(), (double)d1, (AbstractSpawner)null, (SpawnReason)SpawnReason.CHUNK_GENERATION) == -1) continue;
                                if (mobentity.func_213380_a((IWorld)world, SpawnReason.CHUNK_GENERATION) && mobentity.func_205019_a((IWorldReader)world)) {
                                    ilivingentitydata = mobentity.func_213386_a(world, world.func_175649_E(mobentity.func_233580_cy_()), SpawnReason.CHUNK_GENERATION, ilivingentitydata, (CompoundNBT)null);
                                    world.func_242417_l((Entity)mobentity);
                                    flag = true;
                                }
                            }
                        }
                        l += rand.nextInt(5) - rand.nextInt(5);
                        i1 += rand.nextInt(5) - rand.nextInt(5);
                        while (l < x || l >= x + 16 || i1 < z || i1 >= z + 16) {
                            l = j1 + rand.nextInt(5) - rand.nextInt(5);
                            i1 = k1 + rand.nextInt(5) - rand.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos getTopNonCollidingPos(IWorldReader level, EntityType<?> entityType, int pX, int pZ) {
        BlockPos blockpos;
        int i = level.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(entityType), pX, pZ);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(pX, i, pZ);
        if (level.func_230315_m_().func_236037_d_()) {
            do {
                blockpos$mutable.func_189536_c(Direction.DOWN);
            } while (!level.func_180495_p((BlockPos)blockpos$mutable).func_196958_f());
            do {
                blockpos$mutable.func_189536_c(Direction.DOWN);
            } while (level.func_180495_p((BlockPos)blockpos$mutable).func_196958_f() && blockpos$mutable.func_177956_o() > 0);
        }
        if (EntitySpawnPlacementRegistry.func_209344_a(entityType) == EntitySpawnPlacementRegistry.PlacementType.ON_GROUND && level.func_180495_p(blockpos = blockpos$mutable.func_177977_b()).func_196957_g((IBlockReader)level, blockpos, PathType.LAND)) {
            return blockpos;
        }
        return blockpos$mutable.func_185334_h();
    }
}

