/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.events;

import net.MrMagicalCart.cartaddon.api.helpers.CartFightingStyleHelper;
import net.MrMagicalCart.cartaddon.init.CartI18n;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;

@Mod.EventBusSubscriber(modid="cartaddon")
public class CartFightingStylesEvents {
    @SubscribeEvent
    public static void onAttributesChange(ItemAttributeModifierEvent event) {
        AttributeModifier mod;
        double bonus;
        ItemStack stack = event.getItemStack();
        if (event.getSlotType() == EquipmentSlotType.MAINHAND && !stack.func_190926_b() && ItemsHelper.isBlunt((ItemStack)stack) && stack.func_77942_o()) {
            bonus = stack.func_77978_p().func_74769_h("bludgeonBonus");
            mod = new AttributeModifier(CartFightingStyleHelper.BLUDGEON_ATTACK_BONUS_ID, "Bludgeon Bonus", bonus, AttributeModifier.Operation.MULTIPLY_BASE);
            if (bonus > 0.0) {
                event.addModifier(Attributes.field_233823_f_, mod);
            } else if (bonus == 0.0) {
                event.removeModifier(Attributes.field_233823_f_, mod);
            }
        }
        if (event.getSlotType() == EquipmentSlotType.MAINHAND && !stack.func_190926_b() && ItemsHelper.isSword((ItemStack)stack) && stack.func_77942_o()) {
            bonus = stack.func_77978_p().func_74769_h("nitoryuSpeedBonus");
            mod = new AttributeModifier(CartFightingStyleHelper.NITORYU_SPEED_BONUS_ID, "Nitoryu Speed Bonus", bonus, AttributeModifier.Operation.ADDITION);
            if (bonus > 0.0) {
                event.addModifier(Attributes.field_233825_h_, mod);
            } else if (bonus == 0.0) {
                event.removeModifier(Attributes.field_233825_h_, mod);
            }
            bonus = stack.func_77978_p().func_74769_h("nitoryuAttackBonus");
            mod = new AttributeModifier(CartFightingStyleHelper.NITORYU_ATTACK_BONUS_ID, "Nitoryu Attack Bonus", bonus, AttributeModifier.Operation.MULTIPLY_BASE);
            if (bonus > 0.0) {
                event.addModifier(Attributes.field_233823_f_, mod);
            } else if (bonus == 0.0) {
                event.removeModifier(Attributes.field_233823_f_, mod);
            }
        }
    }

    @SubscribeEvent
    public static void onItemChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = event.getTo();
        if (!stack.func_190926_b() && ItemsHelper.isBlunt((ItemStack)stack)) {
            if (!stack.func_77942_o()) {
                stack.func_196082_o();
            }
            if (EntityStatsCapability.get((LivingEntity)entity).getFightingStyle().equals((Object)CartValues.BLUDGEON)) {
                stack.func_77978_p().func_74780_a("bludgeonBonus", EntityStatsCapability.get((LivingEntity)entity).getDoriki() * 3.5E-5);
            } else {
                stack.func_77978_p().func_82580_o("bludgeonBonus");
            }
        }
        if (!stack.func_190926_b() && ItemsHelper.isSword((ItemStack)stack)) {
            if (!stack.func_77942_o()) {
                stack.func_196082_o();
            }
            if (EntityStatsCapability.get((LivingEntity)entity).getFightingStyle().equals((Object)CartValues.NITORYU)) {
                stack.func_77978_p().func_74780_a("nitoryuSpeedBonus", EntityStatsCapability.get((LivingEntity)entity).getDoriki() * 5.0E-5);
                stack.func_77978_p().func_74780_a("nitoryuAttackBonus", EntityStatsCapability.get((LivingEntity)entity).getDoriki() * 1.0E-5);
            } else {
                stack.func_77978_p().func_82580_o("nitoryuSpeedBonus");
                stack.func_77978_p().func_82580_o("nitoryuAttackBonus");
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onTooltipRender(ItemTooltipEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player != null) {
            if (ItemsHelper.isBlunt((ItemStack)event.getItemStack()) && EntityStatsCapability.get((LivingEntity)event.getPlayer()).getFightingStyle().equals((Object)CartValues.BLUDGEON)) {
                StringTextComponent damageBonus = new StringTextComponent(TextFormatting.BLUE + "" + new TranslationTextComponent(CartI18n.ITEM_BLUDGEON_BONUS).getString());
                if (!event.getToolTip().contains(damageBonus)) {
                    event.getToolTip().add(new StringTextComponent(""));
                    event.getToolTip().add(damageBonus);
                }
            }
            if (ItemsHelper.isSword((ItemStack)event.getItemStack()) && EntityStatsCapability.get((LivingEntity)event.getPlayer()).getFightingStyle().equals((Object)CartValues.NITORYU)) {
                StringTextComponent bonus = new StringTextComponent(TextFormatting.DARK_PURPLE + "" + new TranslationTextComponent(CartI18n.ITEM_NITORYU_BONUS).getString());
                if (!event.getToolTip().contains(bonus)) {
                    event.getToolTip().add(new StringTextComponent(""));
                    event.getToolTip().add(bonus);
                }
            }
        }
    }
}

