/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.swordsmenextra;

import java.awt.Color;
import net.MrMagicalCart.cartaddon.abilities.swordsmenextra.VoidShatteringSlashAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.swordsmenextra.SwordsmenExtraProjectiles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class VoidShatteringSlashProjectile
extends AbilityProjectileEntity {
    Vector3d look;
    int col;

    public VoidShatteringSlashProjectile(EntityType type, World world) {
        super(type, world);
        this.look = Vector3d.field_186680_a;
        this.col = 0xFF0000;
    }

    public VoidShatteringSlashProjectile(World world, LivingEntity entity) {
        super((EntityType)SwordsmenExtraProjectiles.VOID_SHATTERING_SLASH.get(), world, entity, VoidShatteringSlashAbility.INSTANCE);
        this.setDamage(75.0f);
        this.setArmorPiercing(1.0f);
        this.setMaxLife(100);
        this.setBlocksAffectedLimit(100000);
        this.look = entity.func_70040_Z();
        this.setPassThroughEntities();
        this.setUnavoidable();
        this.col = HakiHelper.getHaoshokuColour((LivingEntity)entity);
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onHit;
    }

    private void onHit(LivingEntity entity) {
        Vector3d knockback = this.look.func_216372_d(2.0, 0.0, 2.0).func_72441_c(0.0, 0.35, 0.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)knockback);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 400, 2, false, false));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0, false, false));
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 5.0f);
        explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(3));
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 50; ++i) {
                Color clientRGB = new Color(this.col);
                ParticleType particleToUse = (ParticleType)ModParticleTypes.CHIYU.get();
                double offsetX = WyHelper.randomDouble() * 1.0;
                double offsetY = WyHelper.randomDouble() * 12.0;
                double offsetZ = WyHelper.randomDouble() * 1.0;
                SimpleParticleData data = new SimpleParticleData(particleToUse);
                data.setColor((float)clientRGB.getRed() / 255.0f, (float)clientRGB.getGreen() / 255.0f, (float)clientRGB.getBlue() / 255.0f, 0.75f);
                data.setLife(25);
                data.setSize(3.0f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(this.func_226277_ct_() + offsetX), (double)(this.func_226278_cu_() + offsetY), (double)(this.func_226281_cx_() + offsetZ));
            }
        }
    }
}

