/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.sunaextra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.sunaextra.ReworkedSablesPesadoAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.sunaextra.SunaExtraProjectiles;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModIndirectEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedSablesPesadoProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(ReworkedSablesPesadoProjectile.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FINISHED = EntityDataManager.func_187226_a(ReworkedSablesPesadoProjectile.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{AirBlockProtectionRule.INSTANCE, CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE}).build();
    public float multiplier = 0.0f;
    public float chargeAmount = 0.0f;

    public ReworkedSablesPesadoProjectile(EntityType type, World world) {
        super(type, world);
    }

    public ReworkedSablesPesadoProjectile(World world, LivingEntity player) {
        super((EntityType)SunaExtraProjectiles.SABLES_PESADO.get(), world, player, ReworkedSablesPesadoAbility.INSTANCE);
        this.setDamage(70.0f);
        this.setMaxLife(400);
        this.setArmorPiercing(0.75f);
        this.setPassThroughEntities();
        this.setCanGetStuckInGround();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70158_ak = true;
        if (this.isFinished()) {
            this.setSize(Math.min(this.getSize() + 8.0f, 90.0f));
            if (this.getSize() >= 90.0f) {
                this.func_70106_y();
            }
            AbilityHelper.setDeltaMovement((Entity)this, (double)0.0, (double)0.0, (double)0.0);
            this.func_70634_a(this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c);
            this.func_70101_b(90.0f, 0.0f);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
        }
        if (!this.field_70170_p.field_72995_K && !this.isFinished()) {
            for (int i = 0; i < 3; ++i) {
                ParticleType particleToUse = (ParticleType)ModParticleTypes.SUNA2.get();
                double offsetX = WyHelper.randomDouble();
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble();
                SimpleParticleData data = new SimpleParticleData(particleToUse);
                data.setLife(10);
                data.setSize(9.0f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(this.func_226277_ct_() + offsetX), (double)(this.func_226278_cu_() + offsetY), (double)(this.func_226281_cx_() + offsetZ));
            }
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        if (!this.isFinished()) {
            ExplosionAbility explosion = super.createExplosion(null, this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 1.0f);
            explosion.doExplosion();
            AbilityHelper.createSphere((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (int)60, (int)5, (boolean)false, (Block)Blocks.field_150350_a, (int)2, (BlockProtectionRule)GRIEF_RULE);
            List damageList = WyHelper.getNearbyLiving((Vector3d)this.func_213303_ch(), (IWorld)this.field_70170_p, (double)13.75, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)this.getThrower()));
            List knockbackList = WyHelper.getNearbyLiving((Vector3d)this.func_213303_ch(), (IWorld)this.field_70170_p, (double)22.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)this.getThrower()));
            ModDamageSource shockwaveSource = new ModIndirectEntityDamageSource(super.getDamageSource().field_76373_n, (Entity)this, (Entity)super.getThrower()).setSourceElement(SourceElement.SHOCKWAVE).setHakiNature(SourceHakiNature.SPECIAL).setSourceTypes(new ArrayList<SourceType>(Arrays.asList(SourceType.INTERNAL))).setPiercing(0.75f);
            for (LivingEntity target : damageList) {
                target.field_70172_ad = 0;
                target.field_70737_aN = 0;
                target.func_70097_a((DamageSource)shockwaveSource, 70.0f * this.chargeAmount);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0, false, false));
            }
            for (LivingEntity target : knockbackList) {
                AbilityHelper.setDeltaMovement((Entity)target, (Vector3d)this.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_186678_a(0.75));
            }
            this.setFinished();
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FINISHED, (Object)false);
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public boolean isFinished() {
        return (Boolean)this.field_70180_af.func_187225_a(FINISHED);
    }

    public void setFinished() {
        this.field_70180_af.func_187227_b(FINISHED, (Object)true);
    }

    public void setChargedAmount(float charge) {
        this.chargeAmount = charge;
    }
}

