/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.sniperextra;

import net.MrMagicalCart.cartaddon.abilities.sniperextra.ReworkedHiNoToriBoshiAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.sniperextra.SniperExtraProjectiles;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedHiNoToriBoshiProjectile
extends AbilityProjectileEntity {
    public ReworkedHiNoToriBoshiProjectile(EntityType type, World world) {
        super(type, world);
        this.setDamage(40.0f);
        this.setBlocksAffectedLimit(512);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    public ReworkedHiNoToriBoshiProjectile(World world, LivingEntity player) {
        this((EntityType)SniperExtraProjectiles.HI_NO_TORI_BOSHI.get(), world, player, ReworkedHiNoToriBoshiAbility.INSTANCE);
    }

    public ReworkedHiNoToriBoshiProjectile(EntityType type, World world, LivingEntity player, AbilityCore<?> parent) {
        super(type, world, player, parent);
        this.setDamage(40.0f);
        this.setBlocksAffectedLimit(512);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        if (hitEntity instanceof CreeperEntity) {
            ((CreeperEntity)hitEntity).func_146079_cb();
        } else {
            AbilityHelper.setSecondsOnFireBy((Entity)hitEntity, (int)5, (LivingEntity)this.getThrower());
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion;
        if (this.field_70170_p.func_180495_p(hit).getBlockState() == ((Block)ModBlocks.OIL_SPILL.get()).func_176223_P()) {
            explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 6.0f);
            explosion.setStaticDamage(25.0f);
            explosion.setFireAfterExplosion(true);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(4));
            explosion.doExplosion();
        } else {
            AbilityHelper.placeBlockIfAllowed((LivingEntity)this.getThrower(), (BlockPos)hit.func_177982_a(0, 1, 0), (BlockState)Blocks.field_150480_ab.func_176223_P(), (BlockProtectionRule)AirBlockProtectionRule.INSTANCE);
        }
        explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 1.0f);
        explosion.setStaticDamage(5.0f);
        explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(2));
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                data.setLife(10);
                data.setSize(1.0f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(this.func_226277_ct_() + offsetX), (double)(this.func_226278_cu_() + 0.2 + offsetY), (double)(this.func_226281_cx_() + offsetZ));
            }
        }
    }
}

