/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.shiro;

import net.MrMagicalCart.cartaddon.entities.projectiles.shiro.ShiroProjectiles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class FireTankCannonProjectile
extends AbilityProjectileEntity {
    private float explosiveDamage;
    private float explosionSize;

    public FireTankCannonProjectile(EntityType type, World world) {
        super(type, world);
    }

    public FireTankCannonProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)ShiroProjectiles.FIRE_TANK_CANNON.get(), world, player, ability);
        this.explosiveDamage = 15.0f;
        this.explosionSize = 5.5f;
        this.setDamage(85.0f);
        this.setArmorPiercing(0.9f);
        this.setMaxLife(90);
        this.setEntityCollisionSize(12.0);
        this.setPassThroughBlocks();
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onTickEvent() {
        if (this.field_70173_aa > 0 && this.field_70173_aa % 2 == 0) {
            ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.explosionSize);
            explosion.setHeightDifference(2);
            explosion.setStaticDamage(this.explosiveDamage);
            explosion.doExplosion();
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 9.0f);
        explosion.setStaticDamage(15.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(true);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 2, false, false));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 100, 2, false, false));
    }
}

