/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.ryusoken;

import net.MrMagicalCart.cartaddon.entities.projectiles.ryusoken.RyusokenProjectiles;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartParticleTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DragonsWrathProjectile
extends AbilityProjectileEntity {
    boolean canGrief = false;

    public DragonsWrathProjectile(EntityType type, World world) {
        super(type, world);
    }

    public DragonsWrathProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)RyusokenProjectiles.DRAGONS_WRATH.get(), world, player, ability);
        this.setDamage(80.0f);
        this.setArmorPiercing(0.6f);
        this.setMaxLife(30);
        this.setPassThroughBlocks();
        this.setPassThroughEntities();
        if (player instanceof PlayerEntity) {
            this.canGrief = true;
        }
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onTickEvent() {
        if (this.field_70173_aa > 0) {
            if (this.field_70173_aa % 2 == 0) {
                ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 5.0f);
                explosion.setHeightDifference(2);
                explosion.setStaticDamage(3.0f);
                explosion.setDestroyBlocks(this.canGrief);
                explosion.doExplosion();
            }
            if (this.field_70173_aa % 5 == 0) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.WRATH.get()), (Entity)this, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_());
                SimpleParticleData data = new SimpleParticleData((ParticleType)CartParticleTypes.WRATH3.get());
                int size = 90 - this.field_70173_aa;
                data.setLife(20);
                data.setSize((float)size);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)super.func_226277_ct_(), (double)super.func_226278_cu_(), (double)super.func_226281_cx_());
            }
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 7.0f);
        explosion.setStaticDamage(3.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(true);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0, false, false));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 2, false, false));
    }
}

