/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.opeextra;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedRoomAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.opeextra.OpeExtraProjectiles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModIndirectEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TaktTossProjectile
extends AbilityProjectileEntity {
    private boolean tossed = false;

    public TaktTossProjectile(EntityType type, World world) {
        super(type, world);
    }

    public TaktTossProjectile(World world, LivingEntity player) {
        super((EntityType)OpeExtraProjectiles.TAKT_TOSS.get(), world, player);
        this.setDamage(0.0f);
        this.setMaxLife(1200);
        this.setCollideWithEntities(false);
        this.setNoVelocityRotation();
        this.setCollideWithBlocks(false);
        this.setAffectedByHardening();
        this.setArmorPiercing(1.0f);
        this.setUnavoidable();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onHitBlock;
    }

    private void onTickEvent() {
        if (DevilFruitHelper.getDifferenceToFloor((Entity)this) > 23.0 && !this.tossed) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.tossed) {
                if (this.getThrower() != null && this.field_70173_aa > 0 && this.getThrower().field_70173_aa > 0) {
                    ReworkedRoomAbility a = (ReworkedRoomAbility)AbilityDataCapability.get((LivingEntity)this.getThrower()).getEquippedAbility(ReworkedRoomAbility.INSTANCE);
                    if (a == null) {
                        this.func_70106_y();
                    }
                    if (!a.isPositionInRoom(this.func_233580_cy_())) {
                        this.func_70106_y();
                    }
                }
            } else {
                this.setGravity(0.025f);
            }
        }
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        if (this.tossed) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0));
        }
    }

    private void onHitBlock(BlockPos blockPos) {
        if (this.tossed) {
            ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 12.0f);
            explosion.setStaticDamage(0.0f);
            explosion.doExplosion();
            List damageList = WyHelper.getNearbyLiving((Vector3d)this.func_213303_ch(), (IWorld)this.field_70170_p, (double)14.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)this.getThrower()));
            List knockbackList = WyHelper.getNearbyLiving((Vector3d)this.func_213303_ch(), (IWorld)this.field_70170_p, (double)17.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)this.getThrower()));
            ModDamageSource source = new ModIndirectEntityDamageSource(super.getDamageSource().field_76373_n, (Entity)this, (Entity)super.getThrower()).setHakiNature(SourceHakiNature.HARDENING).setUnavoidable().setPiercing(1.0f);
            for (LivingEntity target : damageList) {
                target.field_70172_ad = 0;
                target.field_70737_aN = 0;
                target.func_70097_a((DamageSource)source, 50.0f);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0));
            }
            for (LivingEntity target : knockbackList) {
                Vector3d speed = target.func_70040_Z().func_216372_d(-1.0, -1.0, -1.0).func_216372_d(1.0, 0.0, 1.0);
                AbilityHelper.setDeltaMovement((Entity)target, (double)speed.field_72450_a, (double)0.25, (double)speed.field_72449_c);
            }
            this.func_70106_y();
        }
    }

    public void setTossed(boolean t) {
        this.tossed = t;
    }
}

