/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.mori;

import net.MrMagicalCart.cartaddon.entities.projectiles.mori.MoriProjectiles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class KinnikuGatlingProjectile
extends AbilityProjectileEntity {
    public KinnikuGatlingProjectile(EntityType type, World world) {
        super(type, world);
    }

    public KinnikuGatlingProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)MoriProjectiles.KINNIKU_GATLING.get(), world, player, ability.getCore());
        this.setDamage(21.0f);
        this.setMaxLife(16);
        this.setCanGetStuckInGround();
        this.setPassThroughEntities();
        super.setFist();
        this.setEntityCollisionSize(5.0, 3.0, 5.0);
        this.setDamageSource(this.getDamageSource());
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 30, 0, false, false));
        hitEntity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0, false, false));
        hitEntity.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 100, 0));
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 3.0f);
        explosion.setStaticDamage(8.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(false);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }
}

