/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.mochi;

import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.MochiProjectiles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class YakiMochiProjectile
extends AbilityProjectileEntity {
    private static final double KNOCKBACK = 7.0;
    private Vector3d lookVec;

    public YakiMochiProjectile(EntityType type, World world) {
        super(type, world);
        this.lookVec = Vector3d.field_186680_a;
    }

    public YakiMochiProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)MochiProjectiles.YAKI_MOCHI.get(), world, player, ability);
        this.setDamage(45.0f);
        this.setArmorPiercing(0.65f);
        this.setMaxLife(5);
        this.setEntityCollisionSize(2.5);
        this.setPassThroughBlocks();
        this.setPassThroughEntities();
        this.lookVec = player.func_70040_Z();
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onTickEvent() {
        if (this.field_70173_aa > 0 && this.field_70173_aa % 2 == 0) {
            ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.5f);
            explosion.setStaticDamage(12.0f);
            explosion.doExplosion();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ParticleType particleToUse = this.field_70173_aa % 2 == 0 ? (ParticleType)ModParticleTypes.MERA.get() : (ParticleType)ModParticleTypes.MERA.get();
                double offsetX = WyHelper.randomDouble() * 0.5;
                double offsetY = WyHelper.randomDouble() * 0.5;
                double offsetZ = WyHelper.randomDouble() * 0.5;
                SimpleParticleData data = new SimpleParticleData(particleToUse);
                data.setLife(5);
                data.setSize(7.0f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(this.func_226277_ct_() + offsetX), (double)(this.func_226278_cu_() + offsetY), (double)(this.func_226281_cx_() + offsetZ));
            }
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 3.0f);
        explosion.setStaticDamage(12.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(true);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        Vector3d speed = this.lookVec.func_72432_b().func_216372_d(7.0, 1.0, 7.0).func_72441_c(0.0, 0.15, 0.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)speed);
        entity.func_70015_d(10);
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, 2, false, false));
        entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 10, 2, false, false));
    }
}

