/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.maguextra;

import net.MrMagicalCart.cartaddon.entities.projectiles.maguextra.NewMaguProjectiles;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.LavaImmuneProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NewDaiFunkaProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{DefaultProtectionRules.CORE_FOLIAGE_ORE, LavaImmuneProtectionRule.INSTANCE}).build();
    private boolean changeLifeTime = true;
    private boolean setGrief = true;

    public NewDaiFunkaProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public NewDaiFunkaProjectile(World world, LivingEntity player, IAbility ability) {
        super((EntityType)NewMaguProjectiles.NEW_DAI_FUNKA.get(), world, player, ability.getCore());
        super.setDamage(80.0f);
        super.setMaxLife(35);
        super.setPassThroughEntities();
        super.setCanGetStuckInGround();
        super.setArmorPiercing(1.0f);
        super.addBlockToIgnore(new Block[]{Blocks.field_150353_l});
        this.setEntityCollisionSize(7.0, 7.0, 7.0);
        this.setBlockCollisionSize(6.0, 2.0, 6.0);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        AbilityHelper.setSecondsOnFireBy((Entity)hitEntity, (int)15, (LivingEntity)this.getThrower());
    }

    private void onBlockImpactEvent(BlockPos hit) {
        if (this.setGrief) {
            AbilityHelper.createFilledSphere((World)this.field_70170_p, (int)((int)super.func_226277_ct_()), (int)((int)super.func_226278_cu_()), (int)((int)super.func_226281_cx_()), (int)3, (Block)Blocks.field_150353_l, (BlockProtectionRule)GRIEF_RULE);
        } else {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.getThrower(), (World)this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), (float)7.5f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(true);
            explosion.setDamageEntities(true);
            explosion.setStaticDamage(3.0f);
            explosion.doExplosion();
            if (this.changeLifeTime) {
                super.setLife(3);
                this.changeLifeTime = false;
            }
        }
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            SimpleParticleData data;
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 2; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                data = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                data.setLife(3);
                data.setSize(2.3f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(super.func_226277_ct_() + offsetX), (double)(super.func_226278_cu_() + offsetY), (double)(super.func_226281_cx_() + offsetZ));
            }
            for (i = 0; i < 2; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                data = new SimpleParticleData((ParticleType)ModParticleTypes.MAGU.get());
                data.setLife(3);
                data.setSize(2.3f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(super.func_226277_ct_() + offsetX), (double)(super.func_226278_cu_() + offsetY), (double)(super.func_226281_cx_() + offsetZ));
            }
        }
    }

    public void setGrief(boolean set) {
        this.setGrief = set;
    }
}

