/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.inuwolf;

import net.MrMagicalCart.cartaddon.abilities.inuwolf.BlowYourHouseDownAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.inuwolf.WolfProjectiles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlowYourHouseDownProjectile
extends AbilityProjectileEntity {
    private static final double KNOCKBACK = 7.0;
    private Vector3d lookVec;

    public BlowYourHouseDownProjectile(EntityType type, World world) {
        super(type, world);
        this.lookVec = Vector3d.field_186680_a;
    }

    public BlowYourHouseDownProjectile(World world, LivingEntity player) {
        super((EntityType)WolfProjectiles.BLOW_YOUR_HOUSE_DOWN.get(), world, player, BlowYourHouseDownAbility.INSTANCE);
        this.setDamage(18.0f);
        this.setArmorPiercing(1.0f);
        this.setMaxLife(15);
        this.setPassThroughEntities();
        this.lookVec = player.func_70040_Z();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        Vector3d speed = this.lookVec.func_72432_b().func_216372_d(7.0, 1.0, 7.0).func_72441_c(0.0, 0.15, 0.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)speed);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0, false, false));
        entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 40, 0, false, false));
        entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 40, 0, false, false));
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 1, false, false));
        entity.func_195064_c(new EffectInstance(Effects.field_76419_f, 40, 0, false, false));
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 3.0f);
        explosion.setStaticDamage(0.0f);
        explosion.setFireAfterExplosion(false);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double offsetX = WyHelper.randomDouble() * 2.0;
                double offsetY = WyHelper.randomDouble() * 2.0;
                double offsetZ = WyHelper.randomDouble() * 2.0;
                SimpleParticleData particleData = new SimpleParticleData((ParticleType)ModParticleTypes.MOKU.get());
                particleData.setLife(30);
                particleData.setSize(3.0f);
                WyHelper.spawnParticles((IParticleData)particleData, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(super.func_226277_ct_() + offsetX), (double)(super.func_226278_cu_() + offsetY), (double)(super.func_226281_cx_() + offsetZ));
            }
        }
    }
}

