/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.inuwolf;

import net.MrMagicalCart.cartaddon.abilities.inuwolf.BigBadScratchAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.inuwolf.WolfProjectiles;
import net.MrMagicalCart.cartaddon.init.CartParticleTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BigBadScratchProjectile
extends AbilityProjectileEntity {
    public BigBadScratchProjectile(EntityType type, World world) {
        super(type, world);
    }

    public BigBadScratchProjectile(World world, LivingEntity player) {
        super((EntityType)WolfProjectiles.BIG_BAD_SCRATCH.get(), world, player, BigBadScratchAbility.INSTANCE);
        this.setDamage(35.0f);
        this.setArmorPiercing(0.75f);
        this.setAffectedByHardening();
        this.setMaxLife(5);
        this.setPassThroughEntities();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 100, 0));
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 3.0f);
        explosion.setStaticDamage(0.0f);
        explosion.setFireAfterExplosion(false);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)CartParticleTypes.WOLF.get());
                data.setLife(15);
                data.setSize(45.0f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(super.func_226277_ct_() + offsetX), (double)(super.func_226278_cu_() - 0.4 + offsetY), (double)(super.func_226281_cx_() + offsetZ));
            }
        }
    }
}

