/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.inuokuchi;

import net.MrMagicalCart.cartaddon.abilities.inuokuchi.NamujiHyogaAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.inuokuchi.OkuchiProjectiles;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NamujiHyogaProjectile
extends AbilityProjectileEntity {
    public NamujiHyogaProjectile(EntityType type, World world) {
        super(type, world);
    }

    public NamujiHyogaProjectile(World world, LivingEntity player) {
        super((EntityType)OkuchiProjectiles.NAMUJI_NYOGA.get(), world, player, NamujiHyogaAbility.INSTANCE);
        this.setDamage(20.0f);
        this.setArmorPiercing(1.0f);
        this.setMaxLife(40);
        this.setPassThroughEntities();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.FROZEN.get(), 130, 0));
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.placeBlockIfAllowed((LivingEntity)this.getThrower(), (BlockPos)hit, (BlockState)Blocks.field_205164_gk.func_176223_P(), (BlockProtectionRule)DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID);
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 3.0f);
        explosion.setStaticDamage(0.0f);
        explosion.setFireAfterExplosion(false);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (this.field_70173_aa > 2) {
            BlockPos pos = super.func_233580_cy_();
            this.onBlockImpactEvent.onImpact(pos);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                double offsetX = WyHelper.randomDouble() * 2.0;
                double offsetY = WyHelper.randomDouble() * 2.0;
                double offsetZ = WyHelper.randomDouble() * 2.0;
                SimpleParticleData particleData = new SimpleParticleData((ParticleType)ModParticleTypes.YUKI.get());
                if (i % 2 == 1) {
                    particleData = new SimpleParticleData((ParticleType)ModParticleTypes.YUKI2.get());
                }
                particleData.setLife(30);
                particleData.setSize(3.0f);
                WyHelper.spawnParticles((IParticleData)particleData, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(super.func_226277_ct_() + offsetX), (double)(super.func_226278_cu_() + offsetY), (double)(super.func_226281_cx_() + offsetZ));
            }
        }
    }
}

