/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.inuokuchi;

import net.MrMagicalCart.cartaddon.abilities.inuokuchi.IcicleBarrageAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.inuokuchi.OkuchiProjectiles;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IcicleBarrageProjectile
extends AbilityProjectileEntity {
    public IcicleBarrageProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IcicleBarrageProjectile(World world, LivingEntity player) {
        super((EntityType)OkuchiProjectiles.ICICLE_BARRAGE.get(), world, player, IcicleBarrageAbility.INSTANCE);
        this.setDamage(12.0f);
        this.setArmorPiercing(0.75f);
        this.setGravity(0.015f);
        this.setMaxLife(400);
        this.setDamageSource(this.getDamageSource().setProjectile());
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.FROZEN.get(), 40, 0));
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.placeBlockIfAllowed((LivingEntity)this.getThrower(), (BlockPos)hit, (BlockState)Blocks.field_205164_gk.func_176223_P(), (BlockProtectionRule)DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.YUKI.get());
                data.setLife(12);
                data.setSize(3.0f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(super.func_226277_ct_() + offsetX), (double)(super.func_226278_cu_() - 0.4 + offsetY), (double)(super.func_226281_cx_() + offsetZ));
            }
        }
    }
}

