/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.goru;

import net.MrMagicalCart.cartaddon.entities.projectiles.goru.GoruProjectiles;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartParticleTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GonBombaProjectile
extends AbilityProjectileEntity {
    private float explosiveDamage;
    private float explosionSize;
    private boolean gonBlast = false;

    public GonBombaProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GonBombaProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)GoruProjectiles.GON_BOMBA.get(), world, player, ability);
        this.explosiveDamage = 15.0f;
        this.explosionSize = 2.5f;
        this.setArmorPiercing(0.55f);
        this.setDamage(25.0f);
        this.setMaxLife(6);
        this.setEntityCollisionSize(6.0);
        this.setPassThroughBlocks();
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
    }

    public GonBombaProjectile(World world, LivingEntity player, Ability ability, boolean tesoro) {
        super((EntityType)GoruProjectiles.GON_BLAST.get(), world, player, ability);
        this.gonBlast = true;
        this.explosiveDamage = 25.0f;
        this.explosionSize = 8.0f;
        this.setArmorPiercing(0.6f);
        this.setDamage(45.0f);
        this.setMaxLife(12);
        this.setEntityCollisionSize(17.0);
        this.setPassThroughBlocks();
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (this.field_70173_aa > 0 && this.field_70173_aa % 2 == 0) {
            ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.explosionSize);
            explosion.setHeightDifference(5);
            explosion.setStaticDamage(this.explosiveDamage);
            explosion.doExplosion();
        }
        if (!this.gonBlast) {
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 2; ++i) {
                    double offsetX = WyHelper.randomDouble() / 5.0;
                    double offsetY = WyHelper.randomDouble() / 5.0;
                    double offsetZ = WyHelper.randomDouble() / 5.0;
                    SimpleParticleData data = new SimpleParticleData((ParticleType)CartParticleTypes.GORU3.get());
                    data.setLife(50);
                    data.setSize(60.0f);
                    WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(super.func_226277_ct_() + offsetX), (double)(super.func_226278_cu_() - 0.4 + offsetY), (double)(super.func_226281_cx_() + offsetZ));
                }
            }
        } else if (this.field_70173_aa % 3 == 0) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.GON_BLAST.get()), (Entity)this, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_());
        }
    }
}

