/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.goroextra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.entities.projectiles.goroextra.GoroExtraProjectiles;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModIndirectEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedRaigoProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private boolean dealtAOE = false;
    private boolean closeToFloor = false;
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{AirBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE, CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE}).build();
    private float EXPLOSION_RADIUS = 0.7f;
    private float SHOCKWAVE_RADIUS = 0.85f;
    public float chargeAmount = 0.0f;
    public float dmg = 40.0f;

    public ReworkedRaigoProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public ReworkedRaigoProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)GoroExtraProjectiles.RAIGO.get(), world, player, ability.getCore());
        super.setDamage(120.0f);
        super.setMaxLife(256);
        super.setEntityCollisionSize(4.0);
        super.setPassThroughEntities();
        super.setCanGetStuckInGround();
        super.setTargetResetTime(120);
        super.setArmorPiercing(0.75f);
        super.setUnavoidable();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    public void onBlockImpactEvent(BlockPos hit) {
        int explosionRadius = (int)(this.EXPLOSION_RADIUS * this.getSize());
        int shockwaveRadius = (int)(this.SHOCKWAVE_RADIUS * this.getSize());
        AbilityHelper.createSphere((World)this.field_70170_p, (BlockPos)this.func_233580_cy_().func_177979_c(explosionRadius / 8), (int)explosionRadius, (int)explosionRadius, (boolean)false, (Block)Blocks.field_150350_a, (int)3, (BlockProtectionRule)GRIEF_RULE);
        if (!this.dealtAOE) {
            List list = WyHelper.getNearbyEntities((Vector3d)this.func_213303_ch(), (IWorld)this.field_70170_p, (double)shockwaveRadius, (Predicate)null, (Class[])new Class[]{Entity.class});
            list.remove(this.getThrower());
            for (Entity target : list) {
                if (target instanceof ThrowableEntity || target instanceof AbstractArrowEntity) {
                    target.func_70106_y();
                }
                ModDamageSource shockwaveSource = new ModIndirectEntityDamageSource(super.getDamageSource().field_76373_n, (Entity)this, (Entity)super.getThrower()).setSourceElement(SourceElement.LIGHTNING).setHakiNature(SourceHakiNature.SPECIAL).setSourceTypes(new ArrayList<SourceType>(Arrays.asList(SourceType.INTERNAL))).setUnavoidable().setPiercing(0.75f);
                if (!(target instanceof LivingEntity)) continue;
                target.func_70097_a((DamageSource)shockwaveSource, 60.0f + this.dmg * this.chargeAmount);
                Vector3d speed = target.func_70040_Z().func_186678_a(-1.0).func_216372_d(5.0, 0.0, 5.0);
                AbilityHelper.setDeltaMovement((Entity)target, (double)speed.field_72450_a, (double)1.0, (double)speed.field_72449_c);
            }
            this.dealtAOE = true;
        }
        this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), (SoundEvent)ModSounds.EL_THOR_SFX.get(), SoundCategory.WEATHER, 25.0f, 0.5f);
    }

    private void onTickEvent() {
        super.setDamage(2.0f * this.getSize());
        if (!this.field_70170_p.field_72995_K) {
            BlockRayTraceResult mop;
            int j;
            for (j = 0; j < 25; ++j) {
                ParticleType goro_particle = ClientConfig.INSTANCE.isGoroBlue() ? (ParticleType)ModParticleTypes.GORO.get() : (ParticleType)ModParticleTypes.GORO_YELLOW.get();
                ParticleType goro2_particle = ClientConfig.INSTANCE.isGoroBlue() ? (ParticleType)ModParticleTypes.GORO2.get() : (ParticleType)ModParticleTypes.GORO2_YELLOW.get();
                ParticleType particleToUse = this.field_70173_aa % 2 == 0 ? goro2_particle : goro_particle;
                double offsetX = WyHelper.randomDouble() * 5.0;
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble() * 5.0;
                SimpleParticleData data = new SimpleParticleData(particleToUse);
                data.setLife(20);
                data.setSize(7.0f);
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(this.func_226277_ct_() + offsetX), (double)(this.func_226278_cu_() + offsetY), (double)(this.func_226281_cx_() + offsetZ));
            }
            this.func_70101_b(0.0f, 90.0f);
            if (!this.closeToFloor && (mop = WyHelper.rayTraceBlocks((Entity)this, (double)30.0)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)) {
                this.setMaxLife(16);
                this.closeToFloor = true;
            }
            if (this.field_70173_aa % 5 == 0) {
                for (j = 0; j < 10; ++j) {
                    float boltLength = (float)WyHelper.randomWithRange((int)36, (int)50);
                    LightningEntity bolt = new LightningEntity((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)WyHelper.randomWithRange((int)0, (int)360), (float)WyHelper.randomWithRange((int)-90, (int)90), boltLength, boltLength, super.getParent());
                    bolt.setAngle(20);
                    bolt.setMaxLife(10);
                    bolt.setDamage(0.0f);
                    bolt.setExplosion(0, false);
                    bolt.setSize(boltLength / 800.0f);
                    bolt.setColor(ClientConfig.INSTANCE.isGoroBlue() ? ElThorAbility.BLUE_THUNDER : ElThorAbility.YELLOW_THUNDER);
                    bolt.setBranches(3);
                    bolt.setSegments(10);
                    this.field_70170_p.func_217376_c((Entity)bolt);
                }
            }
        }
    }

    public float getSize() {
        return (float)super.func_174813_aQ().func_72320_b() * 4.0f;
    }

    public void increaseSize(float increaseAmount) {
        float size = (float)super.func_174813_aQ().func_72320_b() + increaseAmount;
        super.setEntityCollisionSize((double)size);
        super.setBlockCollisionSize((double)size);
    }

    public void setChargedAmount(float charge) {
        this.chargeAmount = charge;
    }

    public void setDmg(float damage) {
        this.dmg = damage;
    }
}

