/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.electro;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartElectricalLunaAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.electro.CartElectroProjectiles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartElectricalLunaProjectile
extends AbilityProjectileEntity {
    private CartElectricalLunaAbility ability;

    public CartElectricalLunaProjectile(EntityType type, World world) {
        super(type, world);
    }

    public CartElectricalLunaProjectile(World world, LivingEntity player, CartElectricalLunaAbility ability) {
        super((EntityType)CartElectroProjectiles.ELECTRICAL_LUNA.get(), world, player, (Ability)ability);
        this.ability = ability;
        this.setMaxLife(25);
        this.setDamage(40.0f);
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onHitBlock;
    }

    private void onHitBlock(BlockPos pos) {
        this.ability.getComponent(ModAbilityKeys.RANGE).ifPresent(comp -> {
            int range = 6;
            List targets = comp.getTargetsInArea(this.getThrower(), (float)range);
            for (LivingEntity target : targets) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 30, 0));
                int amount = 16;
                for (int j = 0; j < amount; ++j) {
                    float boltSize = (float)WyHelper.randomWithRange((int)3, (int)range);
                    LightningEntity bolt = new LightningEntity((Entity)this, (double)target.func_233580_cy_().func_177958_n(), (double)target.func_233580_cy_().func_177956_o() + 0.25, (double)target.func_233580_cy_().func_177952_p(), (float)WyHelper.randomWithRange((int)0, (int)360), (float)WyHelper.randomWithRange((int)0, (int)5), boltSize, 8.0f, this.ability.getCore());
                    bolt.setAngle(60);
                    bolt.setMaxLife(20);
                    bolt.setDamage(0.0f);
                    bolt.setExplosion(0, false);
                    bolt.setSize(boltSize / 600.0f);
                    bolt.setBranches((int)WyHelper.randomWithRange((int)1, (int)3));
                    bolt.setSegments((int)((double)boltSize * 0.6));
                    bolt.setLightningMimic(false);
                    this.field_70170_p.func_217376_c((Entity)bolt);
                }
            }
        });
    }

    private void onTickEvent() {
        if (this.field_70173_aa >= 0) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.ELECTRICAL_LUNA.get()), (Entity)this, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_());
        }
    }
}

