/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.dokuextra;

import net.MrMagicalCart.cartaddon.abilities.dokuextra.NewVenomRoadAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.dokuextra.NewDokuProjectiles;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class NewVenomRoadProjectile
extends AbilityProjectileEntity {
    private boolean isDemonMode = false;
    private Vector3d startPos;
    private NewVenomRoadAbility parent;

    public NewVenomRoadProjectile(EntityType type, World world) {
        super(type, world);
    }

    public NewVenomRoadProjectile(World world, LivingEntity player, NewVenomRoadAbility parent, boolean isDemonMode) {
        super((EntityType)NewDokuProjectiles.NEW_VENOM_ROAD.get(), world, player, NewVenomRoadAbility.INSTANCE);
        this.parent = parent;
        this.setDamage(isDemonMode ? 15.0f : 8.0f);
        this.field_70158_ak = true;
        this.setMaxLife(isDemonMode ? 40 : 30);
        this.setPassThroughEntities();
        this.isDemonMode = isDemonMode;
        this.startPos = player.func_213303_ch();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos pos) {
        BlockState state;
        LivingEntity thrower = this.getThrower();
        if (thrower != null && AbilityHelper.canUseMomentumAbilities((LivingEntity)thrower) && !(state = thrower.field_70170_p.func_180495_p(pos)).func_177230_c().isAir(state, (IBlockReader)this.field_70170_p, pos)) {
            if (thrower.func_184187_bx() != null) {
                thrower.func_184210_p();
            }
            thrower.func_184210_p();
            thrower.func_223102_j((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            thrower.field_70143_R = 0.0f;
            if (this.getThrower() != null) {
                this.parent.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown(this.getThrower(), 80.0f));
            }
        }
    }

    public void func_70071_h_() {
        if (this.getLife() <= 0 && this.getLife() > -1200) {
            this.setLife(this.getLife() - 1);
            AbilityHelper.setDeltaMovement((Entity)this, (double)0.0, (double)0.0, (double)0.0);
        } else {
            super.func_70071_h_();
        }
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 400, this.isDemonMode ? 3 : 1));
        hitEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 400, this.isDemonMode ? 2 : 1));
        hitEntity.func_195064_c(new EffectInstance(Effects.field_76419_f, 400, this.isDemonMode ? 2 : 1));
        hitEntity.func_195064_c(new EffectInstance(Effects.field_76431_k, 400, this.isDemonMode ? 2 : 1));
    }

    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.isDemonMode);
        buffer.writeDouble(this.startPos != null ? this.startPos.field_72450_a : 0.0);
        buffer.writeDouble(this.startPos != null ? this.startPos.field_72448_b : 0.0);
        buffer.writeDouble(this.startPos != null ? this.startPos.field_72449_c : 0.0);
    }

    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.isDemonMode = buffer.readBoolean();
        this.startPos = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public Vector3d getStartPos() {
        return this.startPos;
    }

    public boolean isDemonMode() {
        return this.isDemonMode;
    }
}

