/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.brawlerextra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.brawlerextra.GalaxyImpactAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.brawlerextra.BrawlerExtraProjectiles;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModIndirectEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GalaxyImpactProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(GalaxyImpactProjectile.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FINISHED = EntityDataManager.func_187226_a(GalaxyImpactProjectile.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{AirBlockProtectionRule.INSTANCE, CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE}).build();

    public GalaxyImpactProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GalaxyImpactProjectile(World world, LivingEntity player) {
        super((EntityType)BrawlerExtraProjectiles.GALAXY_IMPACT.get(), world, player, GalaxyImpactAbility.INSTANCE);
        this.setDamage(60.0f);
        this.setMaxLife(400);
        this.setGravity(12.0f);
        this.setArmorPiercing(1.0f);
        this.setCanGetStuckInGround();
        this.setPassThroughEntities();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70158_ak = true;
        if (this.isFinished()) {
            this.setSize(Math.min(this.getSize() + 0.5f, 50.0f));
            AbilityHelper.setDeltaMovement((Entity)this, (double)0.0, (double)0.0, (double)0.0);
            this.func_70634_a(this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c);
            this.func_70101_b(90.0f, 0.0f);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        BlockPos pos = new BlockPos(this.func_233580_cy_().func_177958_n(), this.func_233580_cy_().func_177956_o() - 6, this.func_233580_cy_().func_177952_p());
        if (!this.isFinished()) {
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ModSounds.GENERIC_EXPLOSION.get(), SoundCategory.PLAYERS, 10.0f, 0.25f);
            if (this.getThrower() != null && this.getThrower() instanceof PlayerEntity) {
                AbilityHelper.createSphere((World)this.field_70170_p, (BlockPos)pos, (int)70, (int)25, (boolean)false, (Block)Blocks.field_150350_a, (int)2, (BlockProtectionRule)GRIEF_RULE);
            }
            List damageList = WyHelper.getNearbyLiving((Vector3d)this.func_213303_ch(), (IWorld)this.field_70170_p, (double)35.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)this.getThrower()));
            List knockbackList = WyHelper.getNearbyLiving((Vector3d)this.func_213303_ch(), (IWorld)this.field_70170_p, (double)70.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)this.getThrower()));
            ModDamageSource shockwaveSource = new ModIndirectEntityDamageSource(super.getDamageSource().field_76373_n, (Entity)this, (Entity)super.getThrower()).setSourceElement(SourceElement.SHOCKWAVE).setHakiNature(SourceHakiNature.IMBUING).setSourceTypes(new ArrayList<SourceType>(Arrays.asList(SourceType.INTERNAL))).setUnavoidable().setPiercing(1.0f);
            for (LivingEntity target : damageList) {
                AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
                target.field_70172_ad = 0;
                target.field_70737_aN = 0;
                target.func_70097_a((DamageSource)shockwaveSource, this.getDamage());
            }
            for (LivingEntity target : knockbackList) {
                Vector3d speed = target.func_70040_Z().func_216372_d(-1.0, -1.0, -1.0).func_216372_d(1.0, 0.0, 1.0);
                AbilityHelper.setDeltaMovement((Entity)target, (double)speed.field_72450_a, (double)0.25, (double)speed.field_72449_c);
            }
            this.setFinished();
        }
        if (this.isFinished()) {
            this.func_70106_y();
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FINISHED, (Object)false);
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public boolean isFinished() {
        return (Boolean)this.field_70180_af.func_187225_a(FINISHED);
    }

    public void setFinished() {
        this.field_70180_af.func_187227_b(FINISHED, (Object)true);
    }
}

