/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.bludgeon;

import net.MrMagicalCart.cartaddon.abilities.bludgeon.KundaliDragonSwarmAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.bludgeon.BludgeonProjectiles;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class KundaliDragonSwarmProjectile
extends AbilityProjectileEntity {
    private ItemStack itemStack = ItemStack.field_190927_a;
    private float zRot;
    private Vector3d lookVec;

    public KundaliDragonSwarmProjectile(EntityType type, World world) {
        super(type, world);
        this.lookVec = Vector3d.field_186680_a;
    }

    public KundaliDragonSwarmProjectile(World world, LivingEntity thrower) {
        this(world, thrower, thrower.func_184614_ca().func_77946_l());
        this.lookVec = thrower.func_70040_Z();
    }

    public KundaliDragonSwarmProjectile(World world, LivingEntity thrower, ItemStack stack) {
        super((EntityType)BludgeonProjectiles.KUNDALI_DRAGON_SWARM.get(), world, thrower, KundaliDragonSwarmAbility.INSTANCE);
        this.itemStack = stack;
        float damage = ItemsHelper.getItemDamage((ItemStack)this.itemStack);
        this.setDamage(damage / 2.0f + 6.0f);
        this.setMaxLife(13);
        this.setAffectedByImbuing();
        this.setEntityCollisionSize(2.0, 2.0, 2.0);
        this.onEntityImpactEvent = this::onHitEntity;
    }

    private void onHitEntity(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 5));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 5));
        Vector3d speed = this.lookVec.func_72432_b().func_216372_d(2.5, 1.0, 2.5).func_72441_c(0.0, 0.15, 0.0);
        entity.func_213317_d(speed);
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.func_150788_a(this.itemStack);
    }

    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.itemStack = buffer.func_150791_c();
    }

    public float getRotation() {
        return this.zRot;
    }
}

