/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.projectiles.batto;

import net.MrMagicalCart.cartaddon.abilities.batto.SonicBoomAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.batto.BattoProjectiles;
import net.MrMagicalCart.cartaddon.init.CartParticleTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SonicBoomProjectile
extends AbilityProjectileEntity {
    public SonicBoomProjectile(EntityType type, World world) {
        super(type, world);
    }

    public SonicBoomProjectile(World world, LivingEntity player) {
        super((EntityType)BattoProjectiles.SONIC_BOOM.get(), world, player, SonicBoomAbility.INSTANCE);
        this.setDamage(35.0f);
        this.setArmorPiercing(1.0f);
        this.setCanGetStuckInGround();
        this.setPassThroughEntities();
        this.setLife(32);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 5));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 200, 0));
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 2));
        entity.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, 0));
        entity.func_195064_c(new EffectInstance(Effects.field_188423_x, 200, 0));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 10, 0));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), 4.0f);
        explosion.setStaticDamage(25.0f);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(3));
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)CartParticleTypes.BATTO.get());
                data.setLife(32);
                data.setSize(35.0f);
                if (this.field_70173_aa % 2 != 0) continue;
                WyHelper.spawnParticles((IParticleData)data, (ServerWorld)((ServerWorld)this.field_70170_p), (double)(super.func_226277_ct_() + offsetX), (double)(super.func_226278_cu_() - 0.4 + offsetY), (double)(super.func_226281_cx_() + offsetZ));
            }
        }
    }
}

