/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.mobs.quests.givers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.MrMagicalCart.cartaddon.api.helpers.CartMobsHelper;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.twinbarrel.BackFlipWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.twinbarrel.BulletBlastBarrageWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.twinbarrel.DangiriganWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.twinbarrel.DoubleShotsWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.twinbarrel.JumpShotsWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.twinbarrel.SpinningBarrelShotsWrapperGoal;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhaseManager;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.SniperTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TwinBarrelTrainerEntity
extends TrainerEntity
implements IHakiTrainer,
IRangedAttackMob {
    protected static final List<Supplier<? extends Item>> GUNS = Arrays.asList(ModWeapons.WALKER, () -> (Item)ModWeapons.FLINTLOCK.get());
    private final NPCPhaseManager phaseManager = new NPCPhaseManager((MobEntity)this);
    private NPCPhase<SniperTrainerEntity> meleePhase;
    private NPCPhase<SniperTrainerEntity> rangePhase;

    public TwinBarrelTrainerEntity(EntityType type, World world) {
        super(type, world, CartMobsHelper.TWIN_BARREL_TEXTURES);
        if (world != null && !world.field_72995_K) {
            this.meleePhase = new SimplePhase("Melee Phase", (MobEntity)this);
            this.rangePhase = new SimplePhase("Range Phase", (MobEntity)this);
            this.getEntityStats().setFaction(ModValues.CIVILIAN);
            this.getEntityStats().setFightingStyle(CartValues.TWIN_BARREL);
            this.getEntityStats().setRace(ModValues.HUMAN);
            ItemStack randomBow = new ItemStack((IItemProvider)GUNS.get(0).get());
            this.func_184201_a(EquipmentSlotType.MAINHAND, randomBow);
            randomBow = new ItemStack((IItemProvider)GUNS.get(1).get());
            this.func_184201_a(EquipmentSlotType.OFFHAND, randomBow);
            this.setDoriki(2000.0 + WyHelper.randomWithRange((int)0, (int)1000));
            this.setBelly(20.0 + WyHelper.randomWithRange((int)0, (int)20));
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(12.0);
            this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true, true));
            this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.2, true));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 120.0f, 4.0f));
            WeightedList goals = new WeightedList(new Object[0]);
            goals.addEntry(() -> new SpinningBarrelShotsWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new BulletBlastBarrageWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new DangiriganWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new DoubleShotsWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new JumpShotsWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new BackFlipWrapperGoal((MobEntity)this), 2.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, (int)5, (WeightedList)goals).forEach(goal -> this.rangePhase.addGoal(2, goal));
            MobsHelper.addBusoshokuHaki((MobEntity)this, (int)100);
            this.phaseManager.setPhase(this.rangePhase);
        }
    }

    private void onStyleSwitched(LivingEntity entity, boolean isRanged) {
        if (isRanged) {
            this.phaseManager.setPhase(this.rangePhase);
        } else {
            this.phaseManager.setPhase(this.meleePhase);
        }
    }

    public void func_70619_bc() {
        this.phaseManager.tick();
    }

    public void func_82196_d(LivingEntity target, float velocity) {
        if (this.func_184614_ca() != null && this.func_184614_ca().func_77973_b().equals(Items.field_151031_f)) {
            NormalBulletProjectile proj = new NormalBulletProjectile(this.field_70170_p, (LivingEntity)this);
            proj.setDamage(5.0f);
            if (this.isAboveNormalDifficulty()) {
                proj = new KairosekiBulletProjectile(this.field_70170_p, (LivingEntity)this);
                proj.setDamage(7.0f);
            }
            proj.func_234612_a_((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, 2.0f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)proj);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233826_i_, 15.0);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public List<QuestId> getAvailableQuests(PlayerEntity player) {
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        ArrayList<QuestId> availableQuests = new ArrayList<QuestId>();
        if (entityProps.getFightingStyle().equals((Object)CartValues.TWIN_BARREL)) {
            availableQuests.addAll(CartQuests.TWIN_BARREL_TRIALS.stream().map(reg -> reg).collect(Collectors.toList()));
        }
        return availableQuests;
    }

    public HakiType getTrainingHaki() {
        return HakiType.BUSOSHOKU;
    }
}

