/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.mobs.marines;

import java.util.UUID;
import net.MrMagicalCart.cartaddon.abilities.generic.ImprovedChargedPunchAbility;
import net.MrMagicalCart.cartaddon.abilities.mokuextra.ReworkedWhiteBlowRushAbility;
import net.MrMagicalCart.cartaddon.abilities.mokuextra.WorldOfSmokeAbility;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ImprovedChargedPunchWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.moku.SmokeBlastWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.moku.WhiteBlowRushWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.moku.WhiteBlowWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.moku.WhiteLauncherWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.moku.WhiteOutWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.moku.WhitePullWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.moku.WorldOfSmokeWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.smoker.SmokerSwitcherGoal;
import net.MrMagicalCart.cartaddon.init.CartArmors;
import net.MrMagicalCart.cartaddon.init.CartEntities;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.moku.MokuLogiaAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.RankyakuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.IPhasesEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.IRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalDamageDealtRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalHitRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.TargetFlyStallingRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.TargetRunningAwayRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SelfHealEatGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.KenbunshokuHakiFutureSightWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.GeppoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.KamieWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.RankyakuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.SoruWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.DyeableModSwordItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SmokerEntity
extends OPBossEntity<SmokerEntity> {
    private static final UUID HARD_WHITE_SNAKE_COOLDOWN_BONUS = UUID.fromString("d902cdbc-0f95-41f5-9ad0-4804c07ecd6b");
    private static final UUID HARD_WORLD_OF_SMOKE_COOLDOWN_BONUS = UUID.fromString("29af9723-439d-4673-8aa6-43d054299f81");
    private static final AttributeModifier GCD_MOD = new AttributeModifier(UUID.fromString("69314cf0-fbcf-4878-bd15-4e2f82b44307"), "GCD Modifier", -5.0, AttributeModifier.Operation.ADDITION);
    private final NPCPhase<SmokerEntity> firstPhase = new SimplePhase("First Phase", (MobEntity)this);
    private final NPCPhase<SmokerEntity> secondPhase = new SimplePhase("Second Phase", (MobEntity)this);
    private final NPCPhase<SmokerEntity> thirdPhase = new SimplePhase("Third Phase", (MobEntity)this);
    private static final int STANDARD_PAIN_THRESHOLD = 100;
    private static final int HARD_PAIN_THRESHOLD = 150;
    private static final int PAIN_GUARD_COOLDOWN = 200;
    private static final int KITING_THRESHOLD = 20;
    private final RevengeMeter painMeter = new RevengeMeter((LivingEntity)this, 999, 0);
    private final RevengeMeter kitingMeter = new RevengeMeter((LivingEntity)this, 100, 1);

    public SmokerEntity(EntityType type, World world) {
        super(type, world);
    }

    public SmokerEntity(InProgressChallenge challenge) {
        super((EntityType)CartEntities.SMOKER.get(), challenge);
    }

    public void initBoss() {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction(ModValues.MARINE);
        this.entityStats.setRace(ModValues.HUMAN);
        this.devilFruitData.setDevilFruit(ModAbilities.MOKU_MOKU_NO_MI);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(3.0);
        this.func_110148_a(Attributes.field_233827_j_).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        ItemStack capeStack = new ItemStack((IItemProvider)CartArmors.R_MARINE_CAPTAIN_CAPE.get());
        capeStack.func_190925_c("display").func_74768_a("color", WyHelper.hexToRGB((String)"#4a583c").getRGB());
        this.func_184201_a(EquipmentSlotType.CHEST, capeStack);
        this.func_184201_a(EquipmentSlotType.MAINHAND, ((DyeableModSwordItem)ModWeapons.JITTE.get()).func_190903_i());
        this.func_184201_a(EquipmentSlotType.HEAD, ((Item)ModItems.THREE_CIGARS.get()).func_190903_i());
        MobsHelper.addBasicNPCGoals((CreatureEntity)this);
        WhiteBlowWrapperGoal whiteBlowWrapperGoal = new WhiteBlowWrapperGoal((MobEntity)this);
        WhiteOutWrapperGoal whiteOutWrapperGoal = new WhiteOutWrapperGoal((MobEntity)this);
        WorldOfSmokeWrapperGoal worldOfSmokeWrapperGoal = new WorldOfSmokeWrapperGoal((MobEntity)this);
        WhiteBlowRushWrapperGoal whiteBlowRushWrapperGoal = new WhiteBlowRushWrapperGoal((MobEntity)this);
        ((ReworkedWhiteBlowRushAbility)whiteBlowRushWrapperGoal.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 200.0f));
        WhitePullWrapperGoal whitePullWrapperGoal = new WhitePullWrapperGoal((MobEntity)this);
        WhiteLauncherWrapperGoal whiteLauncherWrapperGoal = new WhiteLauncherWrapperGoal((MobEntity)this);
        SoruWrapperGoal soruWrapperGoal = new SoruWrapperGoal((MobEntity)this);
        GeppoWrapperGoal geppoWrapperGoal = new GeppoWrapperGoal((MobEntity)this);
        RankyakuWrapperGoal rankyakuWrapperGoal = new RankyakuWrapperGoal((MobEntity)this);
        ((RankyakuAbility)rankyakuWrapperGoal.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 160.0f));
        ImprovedMeleeAttackGoal meleeAttackGoal = new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.0, true);
        this.field_70714_bg.func_75776_a(0, (Goal)new AlwaysActiveAbilityWrapperGoal((MobEntity)this, MokuLogiaAbility.INSTANCE));
        this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
        this.firstPhase.addGoal(1, (Goal)meleeAttackGoal);
        this.firstPhase.addGoal(3, (Goal)whiteBlowWrapperGoal);
        this.firstPhase.addGoal(3, (Goal)whiteBlowRushWrapperGoal);
        this.firstPhase.addGoal(3, (Goal)soruWrapperGoal);
        this.firstPhase.addGoal(3, (Goal)geppoWrapperGoal);
        this.firstPhase.addGoal(3, (Goal)rankyakuWrapperGoal);
        KamieWrapperGoal kamieWrapper = new KamieWrapperGoal((MobEntity)this);
        this.firstPhase.addGoal(0, (Goal)kamieWrapper);
        ImprovedChargedPunchWrapperGoal chargedPunchWrapperGoal = new ImprovedChargedPunchWrapperGoal((MobEntity)this);
        ((ImprovedChargedPunchAbility)chargedPunchWrapperGoal.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 200.0f));
        this.painMeter.addCheck((IRevengeCheck)new PhysicalHitRevengeCheck(1));
        this.painMeter.addCheck((IRevengeCheck)new PhysicalDamageDealtRevengeCheck());
        this.kitingMeter.addCheck((IRevengeCheck)new TargetFlyStallingRevengeCheck(1));
        this.kitingMeter.addCheck((IRevengeCheck)new TargetRunningAwayRevengeCheck(1, 10.0f));
        this.field_70714_bg.func_75776_a(0, (Goal)new SmokerSwitcherGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SelfHealEatGoal((MobEntity)this));
        this.firstPhase.addGoal(3, (Goal)chargedPunchWrapperGoal);
        this.firstPhase.addGoal(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 400.0f, 2.0f));
        this.firstPhase.addGoal(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 400.0f, 2.0f));
        this.secondPhase.addGoal(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 300.0f, 2.5f));
        this.secondPhase.addGoal(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 300.0f, 2.5f));
        this.secondPhase.addGoal(1, (Goal)meleeAttackGoal);
        this.secondPhase.addGoal(3, (Goal)whiteBlowWrapperGoal);
        this.secondPhase.addGoal(3, (Goal)whiteOutWrapperGoal);
        this.secondPhase.addGoal(3, (Goal)whiteBlowRushWrapperGoal);
        this.secondPhase.addGoal(3, (Goal)whitePullWrapperGoal);
        this.secondPhase.addGoal(3, (Goal)whiteLauncherWrapperGoal);
        this.secondPhase.addGoal(3, (Goal)soruWrapperGoal);
        this.secondPhase.addGoal(3, (Goal)geppoWrapperGoal);
        this.secondPhase.addGoal(3, (Goal)rankyakuWrapperGoal);
        this.secondPhase.addGoal(0, (Goal)kamieWrapper);
        this.secondPhase.addGoal(3, (Goal)chargedPunchWrapperGoal);
        this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(6000.0);
            this.hakiCapability.setBusoshokuHakiExp(50.0f);
            this.hakiCapability.setKenbunshokuHakiExp(50.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(6.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
            this.getPhaseManager().setPhase(this.firstPhase);
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(6.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(10.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(500.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
            ((WorldOfSmokeAbility)worldOfSmokeWrapperGoal.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_WORLD_OF_SMOKE_COOLDOWN_BONUS, "Hard World of Smoke Cooldown Bonus", BonusOperation.ADD, -100.0f));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.secondPhase.addGoal(0, (Goal)new KenbunshokuHakiFutureSightWrapperGoal((MobEntity)this));
            this.secondPhase.addGoal(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 250.0f, 2.5f));
            this.secondPhase.addGoal(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 250.0f, 2.5f));
            this.thirdPhase.addGoal(0, (Goal)new KenbunshokuHakiFutureSightWrapperGoal((MobEntity)this));
            this.thirdPhase.addGoal(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 250.0f, 3.0f));
            this.thirdPhase.addGoal(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 250.0f, 3.0f));
            this.thirdPhase.addGoal(0, (Goal)kamieWrapper);
            this.thirdPhase.addGoal(1, (Goal)meleeAttackGoal);
            this.thirdPhase.addGoal(3, (Goal)chargedPunchWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)whiteBlowWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)whiteOutWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)whiteBlowRushWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)worldOfSmokeWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)whiteLauncherWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)soruWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)geppoWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)rankyakuWrapperGoal);
            this.thirdPhase.addGoal(3, (Goal)new SmokeBlastWrapperGoal((MobEntity)this));
            this.getPhaseManager().setPhase(this.secondPhase);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.28f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 450.0).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233820_c_, 0.8);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.painMeter.tick();
            this.kitingMeter.tick();
        }
    }

    public void startSecondPhase() {
        this.getPhaseManager().setPhase(this.secondPhase);
    }

    public void startThirdPhase() {
        this.getPhaseManager().setPhase(this.thirdPhase);
    }

    public boolean isFirstPhaseActive() {
        return this.firstPhase.isActive((IPhasesEntity)this);
    }

    public boolean isSecondPhaseActive() {
        return this.secondPhase.isActive((IPhasesEntity)this);
    }

    public boolean isThirdPhaseActive() {
        return this.thirdPhase.isActive((IPhasesEntity)this);
    }

    public RevengeMeter getPainMeter() {
        return this.painMeter;
    }
}

