/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.mobs.marines;

import java.util.Random;
import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.config.CartCommonConfig;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.generic.ImprovedBellyFlopWrapperGoal;
import net.MrMagicalCart.cartaddon.init.CartEntities;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.entities.IThreatLevel;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FightingStyleHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SpinningBrawlWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.cyborg.RadicalBeamWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class PacifistaMarkTwoEntity
extends OPEntity
implements ICommandReceiver,
IThreatLevel {
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;

    public PacifistaMarkTwoEntity(World world) {
        this((EntityType)CartEntities.PACIFISTA_TWO.get(), world);
    }

    public PacifistaMarkTwoEntity(EntityType type, World world) {
        super(type, world);
        if (world != null && !world.field_72995_K) {
            this.getEntityStats().setRace(ModValues.CYBORG);
            this.getEntityStats().setFaction(ModValues.MARINE);
            this.getEntityStats().setFightingStyle(ModValues.BRAWLER);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(6.0);
            this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(1.3);
            MobsHelper.addBasicNPCGoals((CreatureEntity)this);
            CommandAbility.addCommandGoals((MobEntity)this);
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.0, true));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 300.0f, 2.0f));
            this.field_70714_bg.func_75776_a(2, (Goal)new RadicalBeamWrapperGoal((MobEntity)this));
            this.setBrawlerDetails();
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.32).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233826_i_, 30.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233824_g_, 2.0);
    }

    public float getThreatLevel() {
        return 1.0f;
    }

    private void setBrawlerDetails() {
        FightingStyleHelper.applyBrawlerModifiers((LivingEntity)this);
        if (this.isAboveNormalDifficulty()) {
            WeightedList goals = new WeightedList(new Object[0]);
            goals.addEntry(() -> new ChargedPunchWrapperGoal((MobEntity)this){}, 2.0f);
            goals.addEntry(() -> new SuplexWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new HakaiHoWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new SpinningBrawlWrapperGoal((MobEntity)this), 1.0f);
            goals.addEntry(() -> new ImprovedBellyFlopWrapperGoal((MobEntity)this), 2.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, (int)3, (WeightedList)goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this, (World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (float)5.0f);
            explosion.setStaticDamage(15.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(3));
            explosion.doExplosion();
        }
    }

    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)commandSender);
        if (!props.isMarine()) {
            return false;
        }
        return props.hasMarineRank(FactionHelper.MarineRank.ADMIRAL);
    }

    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    public boolean canMaintainCommand() {
        return this.lastCommandSender == null || !this.lastCommandSender.func_70089_S() || !EntityStatsCapability.get((LivingEntity)this.lastCommandSender).isRogue();
    }

    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    public long getLastCommandTime() {
        return this.lastCommandTime;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public static boolean checkSpawnRules(EntityType<? extends OPEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        double chance = random.nextDouble() * 100.0;
        return chance > CartCommonConfig.INSTANCE.getPXIISpawnChance() ? false : OPEntity.checkSpawnRules(type, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }
}

