/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.mobs.ability;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.hoya.MajinCheappoWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.hoya.MajinSaidanWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.projectiles.hoya.HoyaProjectiles;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiEmissionAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiInternalDestructionAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.NightmareSoldierEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.AbstractBanditEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FactionHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiEmissionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.OTatsumakiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.AbstractMarineEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AbstractPirateEntity;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MajinEntity
extends OPEntity
implements ICommandReceiver,
IEntityAdditionalSpawnData {
    @Nullable
    private UUID ownerId;
    @Nullable
    private LivingEntity owner;
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;

    public MajinEntity(EntityType type, World world) {
        super(type, world);
    }

    public MajinEntity(World world, LivingEntity owner) {
        super((EntityType)HoyaProjectiles.MAJIN.get(), world);
        if (world != null && !world.field_72995_K) {
            this.setOwner(owner);
            this.setDetails();
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            props.setHeart(false);
            props.setShadow(true);
            IHakiData ownerHakiProps = HakiDataCapability.get((LivingEntity)owner);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)this);
            hakiProps.setBusoshokuHakiExp(ownerHakiProps.getBusoshokuHakiExp());
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(9.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(24.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(13.0);
            this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(8.0);
            ((GroundPathNavigator)this.func_70661_as()).func_179688_b(false);
            this.field_70714_bg.func_75776_a(2, (Goal)new MajinSaidanWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new MajinCheappoWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new OTatsumakiWrapperGoal((MobEntity)this));
            if (EntityStatsCapability.get((LivingEntity)owner).getDoriki() < 10000.0) {
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(150.0 + EntityStatsCapability.get((LivingEntity)owner).getDoriki() / 50.0);
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(12.0 + EntityStatsCapability.get((LivingEntity)owner).getDoriki() / 1000.0);
            } else {
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(350.0);
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(22.0);
            }
        }
    }

    protected void func_184651_r() {
        CommandAbility.addCommandGoals((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new OpenDoorGoal((MobEntity)this, false));
        this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 250.0f, 2.5f));
        this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 250.0f, 2.5f));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AbstractMarineEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AbstractPirateEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AbstractBanditEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233821_d_, 0.65).func_233815_a_(Attributes.field_233823_f_, 22.0).func_233815_a_(Attributes.field_233818_a_, 650.0).func_233815_a_(Attributes.field_233820_c_, 3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
    }

    public boolean func_70097_a(DamageSource damageSource, float damageValue) {
        return damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof PlayerEntity && damageSource.func_76346_g() == this.getOwner() ? false : super.func_70097_a(damageSource, damageValue);
    }

    public boolean func_70652_k(Entity target) {
        boolean flag;
        float damage = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        int knockback = 0;
        if (target instanceof LivingEntity) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)target).func_70668_bt());
            knockback = (int)((float)knockback + (float)EnchantmentHelper.func_77501_a((LivingEntity)this));
        }
        if ((flag = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) && knockback > 0) {
            target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70125_A * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70125_A * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
        }
        return flag;
    }

    private void setDetails() {
        ItemStack randomSword = this.getRandomSword(MobsHelper.MARINE_SWORDS);
        if (this.getEntityStats().isMarine() && randomSword.func_77973_b() instanceof IDyeableArmorItem) {
            randomSword.func_190925_c("display").func_74768_a("color", MobsHelper.MARINE_BLUE_COLOR.getRGB());
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getOwner() == null || !this.getOwner().func_70089_S()) {
                this.func_70106_y();
                return;
            }
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MAJIN_PUFF.get()), (Entity)this, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_());
        }
        super.func_70071_h_();
    }

    public EntitySize func_213305_a(Pose pose) {
        return super.func_213305_a(pose);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.ownerId != null) {
            nbt.func_186854_a("ownerId", this.ownerId);
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("ownerId")) {
            this.ownerId = nbt.func_186857_a("ownerId");
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179252_a(this.ownerId);
    }

    public void readSpawnData(PacketBuffer data) {
        this.ownerId = data.func_179253_g();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setOwner(LivingEntity owner) {
        IAbilityData abilityProps;
        this.owner = owner;
        this.ownerId = owner.func_110124_au();
        IEntityStats stats = EntityStatsCapability.get((LivingEntity)this);
        stats.setFaction(EntityStatsCapability.get((LivingEntity)owner).getFaction());
        Predicate factionScope = ModEntityPredicates.getEnemyFactions((LivingEntity)this);
        Predicate<Entity> notSame = entity -> !(entity instanceof NightmareSoldierEntity);
        if (factionScope != null) {
            this.field_70715_bh.func_75776_a(1, (Goal)new FactionHurtByTargetGoal((CreatureEntity)this, factionScope, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, true, factionScope.and(notSame)));
        }
        if ((abilityProps = AbilityDataCapability.get((LivingEntity)owner)).hasUnlockedAbility(BusoshokuHakiInternalDestructionAbility.INSTANCE)) {
            this.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
        } else if (abilityProps.hasUnlockedAbility(BusoshokuHakiEmissionAbility.INSTANCE)) {
            this.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiEmissionWrapperGoal((MobEntity)this));
        } else if (abilityProps.hasUnlockedAbility(BusoshokuHakiHardeningAbility.INSTANCE)) {
            this.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiHardeningWrapperGoal((MobEntity)this));
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.owner == null && this.ownerId != null) {
            this.owner = this.field_70170_p.func_217371_b(this.ownerId);
        }
        return this.owner;
    }

    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        return this.getOwner().equals((Object)commandSender);
    }

    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    public long getLastCommandTime() {
        return this.lastCommandTime;
    }
}

