/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.mobs;

import java.util.Random;
import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.api.helpers.CartMobsHelper;
import net.MrMagicalCart.cartaddon.config.CartCommonConfig;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ryusoken.DancingDragonSlamWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ryusoken.PenetratingClawsWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ryusoken.PreciseClawStrikesWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ryusoken.RyuNoKagizumeWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ryusoken.TalonRushWrapperGoal;
import net.MrMagicalCart.cartaddon.init.CartArmors;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FightingStyleHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.GenkotsuMeteorWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SpinningBrawlWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartOfficerEntity
extends OPEntity
implements ICommandReceiver {
    private static final ResourceLocation[] STYLES = new ResourceLocation[]{ModValues.BRAWLER, CartValues.RYUSOKEN};
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;

    public CartOfficerEntity(EntityType type, World world, ResourceLocation faction) {
        super(type, world, (ResourceLocation[])null);
        if (world != null && !world.field_72995_K) {
            ResourceLocation style = STYLES[this.func_70681_au().nextInt(STYLES.length)];
            this.getEntityStats().setFaction(faction);
            this.getEntityStats().setFightingStyle(style);
            this.getEntityStats().setRace(ModValues.MINK);
            this.getEntityStats().setSubRace("mink_bunny");
            this.setDetails();
            boolean isHardDifficulty = this.isAboveNormalDifficulty();
            this.setDoriki(2000.0 + WyHelper.randomWithRange((int)0, (int)1500) + (isHardDifficulty ? WyHelper.randomWithRange((int)0, (int)500) : 0.0));
            this.setBelly(10.0 + WyHelper.randomWithRange((int)0, (int)20));
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(60.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(1.3);
            MobsHelper.addBasicNPCGoals((CreatureEntity)this);
            CommandAbility.addCommandGoals((MobEntity)this);
            this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.0, true));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 200.0f, 3.0f));
            CartMobsHelper.addElectroAbilities((MobEntity)this, 4);
            MobsHelper.addBusoshokuHaki((MobEntity)this, (int)25);
            ItemStack cape = new ItemStack((IItemProvider)CartArmors.DRIPPY_CAPE.get());
            cape.func_190925_c("display").func_74768_a("color", WyHelper.hexToRGB((String)"#44533c").getRGB());
            this.func_184201_a(EquipmentSlotType.CHEST, cape);
        }
    }

    public static CartOfficerEntity createRevolutionaryOfficer(EntityType type, World world) {
        return new CartOfficerEntity(type, world, ModValues.REVOLUTIONARY);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.4).func_233815_a_(Attributes.field_233823_f_, WyHelper.randomWithRange((int)3, (int)4)).func_233815_a_(Attributes.field_233818_a_, WyHelper.randomWithRange((int)80, (int)120)).func_233815_a_(Attributes.field_233826_i_, WyHelper.randomWithRange((int)4, (int)8));
    }

    protected boolean func_225511_J_() {
        return true;
    }

    private void setDetails() {
        IEntityStats props = this.getEntityStats();
        if (props.isRevolutionary()) {
            this.setRevDetails();
        }
        this.chooseTexture();
        if (props.isBrawler()) {
            this.setBrawlerDetails();
        } else if (props.getFightingStyle().equals((Object)CartValues.RYUSOKEN)) {
            this.setRyusokenDetails();
        }
    }

    private void setBrawlerDetails() {
        FightingStyleHelper.applyBrawlerModifiers((LivingEntity)this);
        if (this.isAboveNormalDifficulty()) {
            WeightedList goals = new WeightedList(new Object[0]);
            goals.addEntry(() -> new GenkotsuMeteorWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new ChargedPunchWrapperGoal((MobEntity)this){}, 3.0f);
            goals.addEntry(() -> new SuplexWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new HakaiHoWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new SpinningBrawlWrapperGoal((MobEntity)this), 1.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, (int)1, (WeightedList)goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
        }
    }

    private void setRyusokenDetails() {
        FightingStyleHelper.applyBrawlerModifiers((LivingEntity)this);
        if (this.isAboveNormalDifficulty()) {
            WeightedList goals = new WeightedList(new Object[0]);
            goals.addEntry(() -> new PreciseClawStrikesWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new RyuNoKagizumeWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new DancingDragonSlamWrapperGoal((MobEntity)this), 1.0f);
            goals.addEntry(() -> new TalonRushWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new PenetratingClawsWrapperGoal((MobEntity)this), 1.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, (int)1, (WeightedList)goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
        }
    }

    private void setRevDetails() {
        this.setTextures(CartMobsHelper.REV_OFFICER_TEXTURES);
    }

    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        if (!this.getEntityStats().isRevolutionary()) {
            return false;
        }
        IEntityStats senderProps = EntityStatsCapability.get((LivingEntity)commandSender);
        if (!senderProps.isRevolutionary()) {
            return false;
        }
        return senderProps.hasRevolutionaryRank(FactionHelper.RevolutionaryRank.COMMANDER);
    }

    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    public boolean canMaintainCommand() {
        return this.lastCommandSender == null || !this.lastCommandSender.func_70089_S() || !EntityStatsCapability.get((LivingEntity)this.lastCommandSender).isRogue();
    }

    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    public long getLastCommandTime() {
        return this.lastCommandTime;
    }

    public static boolean checkSpawnRules(EntityType<? extends OPEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        double chance = random.nextDouble() * 100.0;
        return chance > CartCommonConfig.INSTANCE.getRevOfficerSpawnChance() ? false : OPEntity.checkSpawnRules(type, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }
}

