/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.entities.mobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.api.helpers.CartMobsHelper;
import net.MrMagicalCart.cartaddon.config.CartCommonConfig;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ryusoken.DancingDragonSlamWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ryusoken.PreciseClawStrikesWrapperGoal;
import net.MrMagicalCart.cartaddon.entities.mobs.goals.abilities.ryusoken.RyuNoKagizumeWrapperGoal;
import net.MrMagicalCart.cartaddon.init.CartArmors;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FightingStyleHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.GenkotsuMeteorWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.KaenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.SakuretsuSabotenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.TetsuBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.TokuyoAburaBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.HiryuKaenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.ShiShishiSonsonWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.YakkodoriWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartGruntEntity
extends OPEntity
implements IRangedAttackMob,
ICommandReceiver {
    private static final ResourceLocation[] STYLES = new ResourceLocation[]{ModValues.BRAWLER, CartValues.RYUSOKEN, ModValues.SNIPER, ModValues.SWORDSMAN};
    private static final Map<String, ArrayList<Supplier<? extends Item>>> MELEE_FACTION_WEAPONS = CartGruntEntity.createFactionWeaponsMap();
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;

    static Map<String, ArrayList<Supplier<? extends Item>>> createFactionWeaponsMap() {
        HashMap<String, ArrayList<Supplier<? extends Item>>> map = new HashMap<String, ArrayList<Supplier<? extends Item>>>();
        map.put("revolutionary", MobsHelper.MARINE_SWORDS);
        return map;
    }

    public CartGruntEntity(EntityType type, World world, ResourceLocation faction) {
        super(type, world, (ResourceLocation[])null);
        if (world != null && !world.field_72995_K) {
            ResourceLocation style = STYLES[this.func_70681_au().nextInt(STYLES.length)];
            this.getEntityStats().setFaction(faction);
            this.getEntityStats().setFightingStyle(style);
            this.getEntityStats().setRace(ModValues.HUMAN);
            this.setDetails();
            boolean isHardDifficulty = this.isAboveNormalDifficulty();
            this.setDoriki(500.0 + WyHelper.randomWithRange((int)0, (int)1000) + (isHardDifficulty ? WyHelper.randomWithRange((int)0, (int)500) : 0.0));
            this.setBelly(5.0 + WyHelper.randomWithRange((int)0, (int)5));
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(60.0);
            MobsHelper.addBasicNPCGoals((CreatureEntity)this);
            CommandAbility.addCommandGoals((MobEntity)this);
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.0, true));
            ItemStack cape = new ItemStack((IItemProvider)CartArmors.DRIPPY_CAPE.get());
            cape.func_190925_c("display").func_74768_a("color", WyHelper.hexToRGB((String)"#44533c").getRGB());
            this.func_184201_a(EquipmentSlotType.CHEST, cape);
        }
    }

    public static CartGruntEntity createRevolutionaryGrunt(EntityType type, World world) {
        return new CartGruntEntity(type, world, ModValues.REVOLUTIONARY);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.32).func_233815_a_(Attributes.field_233823_f_, WyHelper.randomWithRange((int)2, (int)3)).func_233815_a_(Attributes.field_233818_a_, WyHelper.randomWithRange((int)20, (int)30)).func_233815_a_(Attributes.field_233826_i_, WyHelper.randomWithRange((int)2, (int)6));
    }

    public void func_82196_d(LivingEntity target, float velocity) {
        if (this.func_184614_ca() != null && this.func_184614_ca().func_77973_b().equals(ModWeapons.FLINTLOCK.get()) && this.func_70638_az() != null) {
            boolean isHardDifficulty = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_193845_a((float)Difficulty.NORMAL.ordinal());
            NormalBulletProjectile proj = new NormalBulletProjectile(this.field_70170_p, (LivingEntity)this);
            proj.setDamage(4.0f);
            if (isHardDifficulty) {
                proj = new KairosekiBulletProjectile(this.field_70170_p, (LivingEntity)this);
                proj.setDamage(5.0f);
            }
            float inaccuracy = Math.max(0, 16 - this.field_70170_p.func_175659_aa().func_151525_a() * 6);
            proj.func_234612_a_((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, 3.0f, inaccuracy);
            this.field_70170_p.func_217376_c((Entity)proj);
            this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.5f, 0.75f + this.func_70681_au().nextFloat() / 4.0f);
        }
    }

    protected boolean func_225511_J_() {
        return true;
    }

    private void setDetails() {
        IEntityStats props = this.getEntityStats();
        if (props.isRevolutionary()) {
            this.setRevDetails();
        }
        this.chooseTexture();
        if (props.isSwordsman()) {
            this.setSwordsmanDetails();
        } else if (props.isSniper()) {
            this.setSniperDetails();
        } else if (props.isBrawler()) {
            this.setBrawlerDetails();
        } else if (props.getFightingStyle().equals((Object)CartValues.RYUSOKEN)) {
            this.setRyusokenDetails();
        }
    }

    private void setSwordsmanDetails() {
        ItemStack randomSword = this.getRandomSword(MELEE_FACTION_WEAPONS.get(this.getEntityStats().getFaction()));
        if (this.getEntityStats().isRevolutionary() && randomSword.func_77973_b() instanceof IDyeableArmorItem) {
            randomSword.func_190925_c("display").func_74768_a("color", CartMobsHelper.REV_COLORS.getRGB());
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
        if (this.isAboveNormalDifficulty()) {
            WeightedList goals = new WeightedList(new Object[0]);
            goals.addEntry(() -> new HiryuKaenWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new ShiShishiSonsonWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new YakkodoriWrapperGoal((MobEntity)this), 1.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, (int)1, (WeightedList)goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
        }
    }

    private void setSniperDetails() {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.FLINTLOCK.get()));
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 40, 15.0f));
        if (this.isAboveNormalDifficulty()) {
            WeightedList goals = new WeightedList(new Object[0]);
            goals.addEntry(() -> new KaenBoshiWrapperGoal((MobEntity)this, 50), 3.0f);
            goals.addEntry(() -> new TokuyoAburaBoshiWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new TetsuBoshiWrapperGoal((MobEntity)this, 60), 1.0f);
            goals.addEntry(() -> new SakuretsuSabotenBoshiWrapperGoal((MobEntity)this, 60), 1.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, (int)1, (WeightedList)goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
        }
    }

    private void setBrawlerDetails() {
        FightingStyleHelper.applyBrawlerModifiers((LivingEntity)this);
        if (this.isAboveNormalDifficulty()) {
            WeightedList goals = new WeightedList(new Object[0]);
            goals.addEntry(() -> new GenkotsuMeteorWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new SuplexWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new HakaiHoWrapperGoal((MobEntity)this), 1.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, (int)1, (WeightedList)goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
        }
    }

    private void setRyusokenDetails() {
        FightingStyleHelper.applyBrawlerModifiers((LivingEntity)this);
        if (this.isAboveNormalDifficulty()) {
            WeightedList goals = new WeightedList(new Object[0]);
            goals.addEntry(() -> new PreciseClawStrikesWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new RyuNoKagizumeWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new DancingDragonSlamWrapperGoal((MobEntity)this), 1.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, (int)1, (WeightedList)goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
        }
    }

    private void setRevDetails() {
        this.setTextures(CartMobsHelper.REV_TEXTURES);
    }

    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        if (!this.getEntityStats().isRevolutionary()) {
            return false;
        }
        IEntityStats senderProps = EntityStatsCapability.get((LivingEntity)commandSender);
        if (!senderProps.isRevolutionary()) {
            return false;
        }
        return senderProps.hasRevolutionaryRank(FactionHelper.RevolutionaryRank.OFFICER);
    }

    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    public boolean canMaintainCommand() {
        return this.lastCommandSender == null || !this.lastCommandSender.func_70089_S() || !EntityStatsCapability.get((LivingEntity)this.lastCommandSender).isRogue();
    }

    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    public long getLastCommandTime() {
        return this.lastCommandTime;
    }

    public static boolean checkSpawnRules(EntityType<? extends OPEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        double chance = random.nextDouble() * 100.0;
        return chance > CartCommonConfig.INSTANCE.getRevGruntSpawnChance() ? false : OPEntity.checkSpawnRules(type, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }
}

